/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.graphnavigation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.AnimalCaretaker;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Child;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Condor;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Elephant;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.GameReserve;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Herd;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.MultiCage;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.OrderLine;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Parent;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.SingleCage;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.User;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Zebra;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.Zoo;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class GraphNavigationTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(GraphNavigationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-graphvalidation", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-graphvalidation", id="b")})
    public void testGraphNavigationDeterminism() {
        User user = new User("John", "Doe");
        Address address1 = new Address(null, "11122", "Stockholm");
        address1.setInhabitant(user);
        Address address2 = new Address("Kungsgatan 5", "11122", "Stockholm");
        address2.setInhabitant(user);
        user.addAddress(address1);
        user.addAddress(address2);
        Order order = new Order(1);
        order.setShippingAddress(address1);
        order.setBillingAddress(address2);
        order.setCustomer(user);
        OrderLine line1 = new OrderLine(order, 42);
        OrderLine line2 = new OrderLine(order, 101);
        order.addOrderLine(line1);
        order.addOrderLine(line2);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)order, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "shippingAddress.addressline1", "customer.addresses[0].addressline1", "billingAddress.inhabitant.addresses[0].addressline1");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-graphvalidation", id="d")})
    public void testNoEndlessLoop() {
        User john = new User("John", null);
        john.knows(john);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)john, new Class[0]);
        Assert.assertEquals((int)constraintViolations.size(), (int)1, (String)"Wrong number of constraints");
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), User.class, null, "lastName");
        User jane = new User("Jane", "Doe");
        jane.knows(john);
        john.knows(jane);
        constraintViolations = validator.validate((Object)john, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), User.class, null, "lastName");
        constraintViolations = validator.validate((Object)jane, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), User.class, null, "knowsUser[0].lastName");
        john.setLastName("Doe");
        constraintViolations = validator.validate((Object)john, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="b")
    public void testTypeOfContainedValueIsDeterminedAtRuntime() {
        SingleCage cage = new SingleCage();
        Elephant elephant = new Elephant();
        elephant.setWeight(500);
        cage.setContainAnimal(elephant);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)cage, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "An elephant weighs at least 1000 kg");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testContainedSet() {
        MultiCage cage = new MultiCage();
        cage.addAnimal(new Zebra(null));
        cage.addAnimal(new Zebra(null));
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)cage, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "A zebra needs a name", "A zebra needs a name");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i")})
    public void testContainedIterable() {
        GameReserve reserve = new GameReserve();
        Herd<Zebra> zebraHerd = new Herd<Zebra>();
        zebraHerd.addAnimal(new Zebra(null));
        zebraHerd.addAnimal(new Zebra(null));
        reserve.setHerd(zebraHerd);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate(reserve, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "A zebra needs a name", "A zebra needs a name");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="k")})
    public void testTypeOfContainedValuesIsDeterminedAtRuntime() {
        Zoo zoo = new Zoo();
        Elephant elephant = new Elephant();
        elephant.setWeight(500);
        zoo.addAnimal(elephant);
        Condor condor = new Condor();
        condor.setWingspan(200);
        zoo.addAnimal(condor);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)zoo, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "The wingspan of a condor is at least 250 cm", "An elephant weighs at least 1000 kg");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="i"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="j")})
    public void testContainedMap() {
        AnimalCaretaker caretaker = new AnimalCaretaker();
        Elephant elephant = new Elephant();
        elephant.setWeight(500);
        caretaker.addAnimal("Jumbo", elephant);
        Condor condor = new Condor();
        condor.setWingspan(200);
        caretaker.addAnimal("Andes", condor);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)caretaker, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "caresFor[Jumbo].weight", "caresFor[Andes].wingspan");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupsequence", id="d")})
    public void testFullGraphValidationBeforeNextGroupInSequence() {
        Parent p = new Parent();
        p.setChild(new Child());
        Validator validator = TestUtil.getValidatorUnderTest();
        Set errors = validator.validate((Object)p, new Class[]{Parent.ProperOrder.class});
        TestUtil.assertCorrectNumberOfViolations(errors, 1);
        TestUtil.assertCorrectPropertyPaths(errors, "child.name");
        p.getChild().setName("Emmanuel");
        errors = validator.validate((Object)p, new Class[]{Parent.ProperOrder.class});
        TestUtil.assertCorrectNumberOfViolations(errors, 1);
        TestUtil.assertCorrectPropertyPaths(errors, "name");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-graphvalidation", id="c")
    public void testNullReferencesGetIgnored() {
        Parent p = new Parent();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set errors = validator.validateProperty((Object)p, "child", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(errors, 0);
    }
}

