/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.groupconversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Address;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.BasicPostal;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Complete;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.Complex;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.EndUserImpl;
import org.hibernate.beanvalidation.tck.tests.validation.groupconversion.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class GroupConversionValidationTest
extends BaseExecutableValidatorTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)TestUtil.webArchiveBuilder().withTestClassPackage(GroupConversionValidationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testGroupConversionIsAppliedOnField() {
        Set constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidMainAddress(), new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "mainAddress.street1", "mainAddress.zipCode");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testSeveralGroupConversionsAppliedOnField() {
        User userWithInvalidPreferredShipmentAddress = TestUsers.withInvalidPreferredShipmentAddress();
        Set constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "preferredShipmentAddress.street1", "preferredShipmentAddress.zipCode");
        constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[]{Complex.class});
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "preferredShipmentAddress.doorCode");
        constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[]{Default.class, Complex.class});
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "preferredShipmentAddress.street1", "preferredShipmentAddress.zipCode", "preferredShipmentAddress.doorCode");
        constraintViolations = this.getValidator().validate((Object)userWithInvalidPreferredShipmentAddress, new Class[]{Complete.class});
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "preferredShipmentAddress.street1", "preferredShipmentAddress.zipCode", "preferredShipmentAddress.doorCode");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnProperty() {
        Set constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidShipmentAddress(), new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "shipmentAddresses[0].street1", "shipmentAddresses[0].zipCode");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnMethodReturnValue() throws Exception {
        User user = TestUsers.validUser();
        Method method = User.class.getMethod("retrieveMainAddress", new Class[0]);
        Address returnValue = TestAddresses.withInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)user, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Path propertyPath = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath();
        TestUtil.assertDescriptorKinds(propertyPath, ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY);
        TestUtil.assertNodeNames(propertyPath, "retrieveMainAddress", "<return value>", "street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionDefinedInSubClassIsAppliedOnMethodReturnValue() throws Exception {
        EndUserImpl user = TestUsers.validEndUser();
        Method method = EndUserImpl.class.getMethod("retrieveWeekendAddress", new Class[0]);
        Address returnValue = TestAddresses.withInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)user, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Path propertyPath = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath();
        TestUtil.assertDescriptorKinds(propertyPath, ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY);
        TestUtil.assertNodeNames(propertyPath, "retrieveWeekendAddress", "<return value>", "street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionDefinedInImplementedClassIsAppliedOnMethodReturnValue() throws Exception {
        EndUserImpl user = TestUsers.validEndUser();
        Method method = EndUserImpl.class.getMethod("retrieveFallbackAddress", new Class[0]);
        Address returnValue = TestAddresses.withInvalidStreet1();
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)user, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Path propertyPath = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath();
        TestUtil.assertDescriptorKinds(propertyPath, ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY);
        TestUtil.assertNodeNames(propertyPath, "retrieveFallbackAddress", "<return value>", "street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnMethodParameter() throws Exception {
        User user = TestUsers.validUser();
        Method method = User.class.getMethod("setMainAddress", Address.class);
        Object[] arguments = new Object[]{TestAddresses.withInvalidStreet1()};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)user, method, arguments, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Path propertyPath = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath();
        TestUtil.assertDescriptorKinds(propertyPath, ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY);
        TestUtil.assertNodeNames(propertyPath, "setMainAddress", "mainAddress", "street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnConstructorReturnValue() throws Exception {
        Constructor constructor = User.class.getConstructor(Address.class);
        User createdObject = new User(TestAddresses.withInvalidStreet1());
        Set constraintViolations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Path propertyPath = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath();
        TestUtil.assertDescriptorKinds(propertyPath, ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY, ElementKind.PROPERTY);
        TestUtil.assertNodeNames(propertyPath, "User", "<return value>", "mainAddress", "street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="c")
    public void testGroupConversionIsAppliedOnConstructorParameter() throws Exception {
        Constructor constructor = User.class.getConstructor(Address.class);
        Object[] arguments = new Object[]{TestAddresses.withInvalidStreet1()};
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(constructor, arguments, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Path propertyPath = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath();
        TestUtil.assertDescriptorKinds(propertyPath, ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY);
        TestUtil.assertNodeNames(propertyPath, "User", "mainAddress", "street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="d")
    public void testGroupConversionIsNotExecutedRecursively() {
        Set constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidOfficeAddress(), new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "officeAddress.street1", "officeAddress.zipCode");
        constraintViolations = this.getValidator().validate((Object)TestUsers.withInvalidOfficeAddress(), new Class[]{BasicPostal.class});
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "officeAddress.doorCode");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="g")
    public void testGroupConversionWithSequenceAsTo() {
        User user = TestUsers.validUser();
        Set constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        user.getWeekendAddress().setDoorCode("ABC");
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "weekendAddress.doorCode");
        user.getWeekendAddress().setStreet1(null);
        constraintViolations = this.getValidator().validate((Object)user, new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "weekendAddress.street1");
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-groupconversion", id="b")
    public void testGroupIsPassedAsIsToNestedElementWithoutConversion() {
        Set constraintViolations = this.getValidator().validate((Object)new FooHolder(), new Class[0]);
        Assert.assertTrue((boolean)constraintViolations.isEmpty(), (String)"No violations expected for default group");
        constraintViolations = this.getValidator().validate((Object)new FooHolder(), new Class[]{Complex.class});
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "foo.bar");
    }

    private static class Foo {
        @NotNull(groups={Complex.class})
        private String bar;

        private Foo() {
        }
    }

    private static class FooHolder {
        @Valid
        private final Foo foo = new Foo();

        private FooHolder() {
        }
    }

    private static class TestAddresses {
        private TestAddresses() {
        }

        public static Address validAddress() {
            return new Address("Main Street", "c/o Hitchcock", "123", "AB");
        }

        public static Address invalidAddress() {
            return new Address(null, null, "12", "ABC");
        }

        public static Address withInvalidStreet1() {
            Address address = TestAddresses.validAddress();
            address.setStreet1(null);
            return address;
        }
    }

    private static class TestUsers {
        private TestUsers() {
        }

        public static User validUser() {
            return new User(TestAddresses.validAddress(), Arrays.asList(TestAddresses.validAddress()), TestAddresses.validAddress(), TestAddresses.validAddress(), TestAddresses.validAddress());
        }

        public static EndUserImpl validEndUser() {
            return new EndUserImpl(TestAddresses.validAddress(), Arrays.asList(TestAddresses.validAddress()), TestAddresses.validAddress(), TestAddresses.validAddress(), TestAddresses.validAddress());
        }

        public static User withInvalidMainAddress() {
            User user = TestUsers.validUser();
            user.setMainAddress(TestAddresses.invalidAddress());
            return user;
        }

        public static User withInvalidShipmentAddress() {
            User user = TestUsers.validUser();
            user.setShipmentAddresses(Arrays.asList(TestAddresses.invalidAddress()));
            return user;
        }

        public static User withInvalidPreferredShipmentAddress() {
            User user = TestUsers.validUser();
            user.setPreferredShipmentAddress(TestAddresses.invalidAddress());
            return user;
        }

        public static User withInvalidOfficeAddress() {
            User user = TestUsers.validUser();
            user.setOfficeAddress(TestAddresses.invalidAddress());
            return user;
        }
    }
}

