/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.spi.ValidationProvider;
import org.hibernate.beanvalidation.tck.tests.BaseExecutableValidatorTest;
import org.hibernate.beanvalidation.tck.tests.BaseValidatorTest;
import org.hibernate.beanvalidation.tck.util.PathNodeKinds;
import org.hibernate.beanvalidation.tck.util.PathNodeNames;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.testng.Assert;
import org.testng.FileAssert;

public final class TestUtil {
    public static final String BEAN_NODE_NAME = null;
    public static final String RETURN_VALUE_NODE_NAME = "<return value>";
    public static final String CROSS_PARAMETER_NODE_NAME = "<cross-parameter>";
    private static final String VALIDATION_PROVIDER_TEST_CLASS = "validation.provider";
    private static ValidationProvider<?> validationProviderUnderTest;

    private TestUtil() {
    }

    public static Validator getValidatorUnderTest() {
        return TestUtil.getValidatorFactoryUnderTest().getValidator();
    }

    public static ValidationProvider<?> getValidationProviderUnderTest() {
        if (validationProviderUnderTest == null) {
            TestUtil.instantiateValidationProviderUnderTest();
        }
        return validationProviderUnderTest;
    }

    public static ValidatorFactory getValidatorFactoryUnderTest() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        return config.buildValidatorFactory();
    }

    public static Configuration<?> getConfigurationUnderTest() {
        if (validationProviderUnderTest == null) {
            TestUtil.instantiateValidationProviderUnderTest();
        }
        ProviderSpecificBootstrap bootstrap = Validation.byProvider(validationProviderUnderTest.getClass());
        return bootstrap.configure();
    }

    public static MessageInterpolator getDefaultMessageInterpolator() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        return config.getDefaultMessageInterpolator();
    }

    public static <T> void assertCorrectNumberOfViolations(Set<ConstraintViolation<T>> violations, int expectedViolations) {
        Assert.assertEquals((int)violations.size(), (int)expectedViolations, (String)("Wrong number of constraint violations. Actual violations: " + violations));
    }

    public static <T> void assertCorrectConstraintViolationMessages(Set<ConstraintViolation<T>> violations, String ... messages) {
        ArrayList<String> actualMessages = new ArrayList<String>();
        for (ConstraintViolation<T> violation : violations) {
            actualMessages.add(violation.getMessage());
        }
        List<String> expectedMessages = Arrays.asList(messages);
        Collections.sort(actualMessages);
        Collections.sort(expectedMessages);
        Assert.assertEquals(actualMessages, expectedMessages, (String)String.format("Expected messages %s, but got %s.", expectedMessages, actualMessages));
    }

    public static void assertCorrectConstraintTypes(Set<? extends ConstraintViolation<?>> violations, Class<?> ... expectedConstraintTypes) {
        ArrayList<String> actualConstraintTypeNames = new ArrayList<String>();
        for (ConstraintViolation<?> violation : violations) {
            actualConstraintTypeNames.add(violation.getConstraintDescriptor().getAnnotation().annotationType().getName());
        }
        ArrayList<String> expectedConstraintTypeNames = new ArrayList<String>();
        for (Class<?> expectedConstraintType : expectedConstraintTypes) {
            expectedConstraintTypeNames.add(expectedConstraintType.getName());
        }
        Collections.sort(actualConstraintTypeNames);
        Collections.sort(expectedConstraintTypeNames);
        Assert.assertEquals(actualConstraintTypeNames, expectedConstraintTypeNames, (String)String.format("Expected %s, but got %s", expectedConstraintTypeNames, actualConstraintTypeNames));
    }

    public static <T> void assertCorrectPropertyPaths(Set<ConstraintViolation<T>> violations, String ... propertyPaths) {
        ArrayList<Path> propertyPathsOfViolations = new ArrayList<Path>();
        for (ConstraintViolation<T> violation : violations) {
            propertyPathsOfViolations.add(violation.getPropertyPath());
        }
        Assert.assertEquals((int)propertyPathsOfViolations.size(), (int)propertyPaths.length, (String)"Wrong number of property paths.");
        for (String propertyPath : propertyPaths) {
            PathImpl expectedPath = PathImpl.createPathFromString(propertyPath);
            boolean containsPath = false;
            for (Path actualPath : propertyPathsOfViolations) {
                if (!TestUtil.assertEqualPaths(expectedPath, actualPath)) continue;
                containsPath = true;
                break;
            }
            if (containsPath) continue;
            FileAssert.fail((String)(expectedPath + " is not in the list of path instances contained in the actual constraint violations: " + propertyPathsOfViolations));
        }
    }

    public static void assertCorrectPathNodeKinds(Set<? extends ConstraintViolation<?>> violations, PathNodeKinds ... kinds) {
        List<PathNodeKinds> actualDescriptorKinds = TestUtil.getPathDescriptorKinds(violations);
        List<PathNodeKinds> expectedDescriptorKinds = Arrays.asList(kinds);
        Collections.sort(actualDescriptorKinds);
        Collections.sort(expectedDescriptorKinds);
        Assert.assertEquals(actualDescriptorKinds, expectedDescriptorKinds);
    }

    public static void assertCorrectPathNodeNames(Set<? extends ConstraintViolation<?>> violations, PathNodeNames ... names) {
        List<PathNodeNames> actualNodeNames = TestUtil.getPathNodeNames(violations);
        List<PathNodeNames> expectedNodeNames = Arrays.asList(names);
        Collections.sort(actualNodeNames);
        Collections.sort(expectedNodeNames);
        Assert.assertEquals(actualNodeNames, expectedNodeNames, (String)String.format("Expected path node names %s, but found %s.", expectedNodeNames, actualNodeNames));
    }

    public static <T> void assertConstraintViolation(ConstraintViolation<T> violation, Class<?> rootBean, Object invalidValue, String propertyPath) {
        PathImpl expectedPath = PathImpl.createPathFromString(propertyPath);
        if (!TestUtil.assertEqualPaths(violation.getPropertyPath(), expectedPath)) {
            FileAssert.fail((String)("Property paths differ. Actual: " + violation.getPropertyPath() + " Expected: " + expectedPath));
        }
        Assert.assertEquals((Object)violation.getRootBeanClass(), rootBean, (String)"Wrong root bean.");
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)invalidValue, (String)"Wrong invalid value.");
    }

    public static void assertDescriptorKinds(Path path, ElementKind ... kinds) {
        Iterator pathIterator = path.iterator();
        for (ElementKind kind : kinds) {
            Assert.assertTrue((boolean)pathIterator.hasNext());
            Assert.assertEquals((Object)((Path.Node)pathIterator.next()).getKind(), (Object)kind);
        }
        Assert.assertFalse((boolean)pathIterator.hasNext());
    }

    public static void assertNodeNames(Path path, String ... names) {
        Iterator pathIterator = path.iterator();
        for (String name : names) {
            Assert.assertTrue((boolean)pathIterator.hasNext());
            Assert.assertEquals((String)((Path.Node)pathIterator.next()).getName(), (String)name);
        }
        Assert.assertFalse((boolean)pathIterator.hasNext());
    }

    public static boolean assertEqualPaths(Path p1, Path p2) {
        Iterator p1Iterator = p1.iterator();
        Iterator p2Iterator = p2.iterator();
        while (p1Iterator.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iterator.next();
            if (!p2Iterator.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iterator.next();
            if (p2Node.getName() == null ? p1Node.getName() != null : !p2Node.getName().equals(p1Node.getName())) {
                return false;
            }
            if (p2Node.isInIterable() != p1Node.isInIterable()) {
                return false;
            }
            if (p2Node.getIndex() == null ? p1Node.getIndex() != null : !p2Node.getIndex().equals(p1Node.getIndex())) {
                return false;
            }
            if (!(p2Node.getKey() == null ? p1Node.getKey() != null : !p2Node.getKey().equals(p1Node.getKey()))) continue;
            return false;
        }
        return !p2Iterator.hasNext();
    }

    public static Set<String> getParameterNames(Set<? extends ConstraintViolation<?>> constraintViolations) {
        HashSet<String> parameterNames = new HashSet<String>();
        for (ConstraintViolation<?> constraintViolation : constraintViolations) {
            parameterNames.add(TestUtil.getParameterName(constraintViolation.getPropertyPath()));
        }
        return parameterNames;
    }

    public static <T> ConstraintViolation<T> getConstraintViolationForParameter(Set<ConstraintViolation<T>> constraintViolations, String parameterName) {
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            if (!parameterName.equals(TestUtil.getParameterName(constraintViolation.getPropertyPath()))) continue;
            return constraintViolation;
        }
        throw new IllegalArgumentException("Found no constraint violation for parameter " + parameterName);
    }

    public static <T> ConstraintViolation<T> getConstraintViolationForConstraintType(Set<ConstraintViolation<T>> constraintViolations, Class<? extends Annotation> constraint) {
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            if (!constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().equals(constraint)) continue;
            return constraintViolation;
        }
        throw new IllegalArgumentException("Found no constraint violation for constraint " + constraint.getSimpleName());
    }

    public static String getParameterName(Path path) {
        Iterator nodes = path.iterator();
        Assert.assertTrue((boolean)nodes.hasNext());
        nodes.next();
        Assert.assertTrue((boolean)nodes.hasNext());
        return ((Path.Node)nodes.next()).getName();
    }

    public static <T> Set<T> asSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static PathNodeKinds kinds(ElementKind ... kinds) {
        return new PathNodeKinds(kinds);
    }

    public static PathNodeNames names(String ... names) {
        return new PathNodeNames(names);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return validator.getConstraintsForClass(clazz).getConstraintsForProperty(property);
    }

    public static MethodDescriptor getMethodDescriptor(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return validator.getConstraintsForClass(clazz).getConstraintsForMethod(name, (Class[])parameterTypes);
    }

    public static ConstructorDescriptor getConstructorDescriptor(Class<?> clazz, Class<?> ... parameterTypes) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return validator.getConstraintsForClass(clazz).getConstraintsForConstructor((Class[])parameterTypes);
    }

    public static Set<ConstraintDescriptor<?>> getConstraintDescriptorsFor(Class<?> clazz, String property) {
        PropertyDescriptor elementDescriptor = TestUtil.getPropertyDescriptor(clazz, property);
        return elementDescriptor.getConstraintDescriptors();
    }

    public static InputStream getInputStreamForPath(String path) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            inputStream = TestUtil.class.getResourceAsStream(path);
        }
        return inputStream;
    }

    public static WebArchiveBuilder webArchiveBuilder() {
        return (WebArchiveBuilder)new WebArchiveBuilder().withClasses(BaseExecutableValidatorTest.class, BaseValidatorTest.class, WebArchiveBuilder.class);
    }

    private static <U extends ValidationProvider<?>> void instantiateValidationProviderUnderTest() {
        Class<?> providerClass;
        String validatorProviderClassName = System.getProperty(VALIDATION_PROVIDER_TEST_CLASS);
        if (validatorProviderClassName == null) {
            throw new RuntimeException("The test harness must specify the class name of the validation provider under test. Set system property 'validation.provider'");
        }
        try {
            Class<?> tmpClazz;
            providerClass = tmpClazz = TestUtil.class.getClassLoader().loadClass(validatorProviderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load " + validatorProviderClassName);
        }
        try {
            validationProviderUnderTest = (ValidationProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + validatorProviderClassName);
        }
    }

    private static List<PathNodeKinds> getPathDescriptorKinds(Set<? extends ConstraintViolation<?>> violations) {
        ArrayList<PathNodeKinds> descriptorKindsOfAllPaths = new ArrayList<PathNodeKinds>();
        for (ConstraintViolation<?> violation : violations) {
            descriptorKindsOfAllPaths.add(new PathNodeKinds(violation.getPropertyPath()));
        }
        return descriptorKindsOfAllPaths;
    }

    private static List<PathNodeNames> getPathNodeNames(Set<? extends ConstraintViolation<?>> violations) {
        ArrayList<PathNodeNames> nodeNamesOfAllPaths = new ArrayList<PathNodeNames>();
        for (ConstraintViolation<?> violation : violations) {
            nodeNamesOfAllPaths.add(new PathNodeNames(violation.getPropertyPath()));
        }
        return nodeNamesOfAllPaths;
    }

    public static class NodeImpl
    implements Path.Node {
        private final String name;
        private boolean isInIterable;
        private Integer index;
        private Object key;

        public NodeImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIterable() {
            return this.isInIterable;
        }

        public void setInIterable(boolean inIterable) {
            this.isInIterable = inIterable;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.isInIterable = true;
            this.index = index;
        }

        public Object getKey() {
            return this.key;
        }

        public ElementKind getKind() {
            throw new UnsupportedOperationException();
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            throw new UnsupportedOperationException();
        }

        public void setKey(Object key) {
            this.isInIterable = true;
            this.key = key;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NodeImpl");
            sb.append("{index=").append(this.index);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", isInIterable=").append(this.isInIterable);
            sb.append(", key=").append(this.key);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class PathImpl
    implements Path {
        private static final Pattern pathPattern = Pattern.compile("(\\w+)(\\[(\\w*)\\])?(\\.(.*))*");
        private static final int PROPERTY_NAME_GROUP = 1;
        private static final int INDEXED_GROUP = 2;
        private static final int INDEX_GROUP = 3;
        private static final int REMAINING_STRING_GROUP = 5;
        private static final String PROPERTY_PATH_SEPARATOR = ".";
        private static final String INDEX_OPEN = "[";
        private static final String INDEX_CLOSE = "]";
        private final List<Path.Node> nodeList = new ArrayList<Path.Node>();

        public static PathImpl createPathFromString(String propertyPath) {
            if (propertyPath == null) {
                throw new IllegalArgumentException("null is not allowed as property path.");
            }
            if (propertyPath.length() == 0) {
                return PathImpl.createNewPath(null);
            }
            return PathImpl.parseProperty(propertyPath);
        }

        public static PathImpl createNewPath(String name) {
            PathImpl path = new PathImpl();
            NodeImpl node = new NodeImpl(name);
            path.addNode(node);
            return path;
        }

        private PathImpl() {
        }

        public void addNode(Path.Node node) {
            this.nodeList.add(node);
        }

        public Iterator<Path.Node> iterator() {
            return this.nodeList.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator<Path.Node> iter = this.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Path.Node node = iter.next();
                if (node.isInIterable()) {
                    this.appendIndex(builder, node);
                }
                if (node.getName() != null) {
                    if (!first) {
                        builder.append(PROPERTY_PATH_SEPARATOR);
                    }
                    builder.append(node.getName());
                }
                first = false;
            }
            return builder.toString();
        }

        private void appendIndex(StringBuilder builder, Path.Node node) {
            builder.append(INDEX_OPEN);
            if (node.getIndex() != null) {
                builder.append(node.getIndex());
            } else if (node.getKey() != null) {
                builder.append(node.getKey());
            }
            builder.append(INDEX_CLOSE);
        }

        private static PathImpl parseProperty(String property) {
            PathImpl path = new PathImpl();
            String tmp = property;
            boolean indexed = false;
            String indexOrKey = null;
            do {
                Matcher matcher;
                if ((matcher = pathPattern.matcher(tmp)).matches()) {
                    String value = matcher.group(1);
                    NodeImpl node = new NodeImpl(value);
                    path.addNode(node);
                    if (indexed) {
                        PathImpl.updateNodeIndexOrKey(indexOrKey, node);
                    }
                } else {
                    throw new IllegalArgumentException("Unable to parse property path " + property);
                }
                indexed = matcher.group(2) != null;
                indexOrKey = matcher.group(3);
                tmp = matcher.group(5);
            } while (tmp != null);
            if (indexed) {
                NodeImpl node = new NodeImpl(null);
                PathImpl.updateNodeIndexOrKey(indexOrKey, node);
                path.addNode(node);
            }
            return path;
        }

        private static void updateNodeIndexOrKey(String indexOrKey, NodeImpl node) {
            node.setInIterable(true);
            if (indexOrKey != null && indexOrKey.length() > 0) {
                try {
                    Integer i = Integer.parseInt(indexOrKey);
                    node.setIndex(i);
                }
                catch (NumberFormatException e) {
                    node.setKey(indexOrKey);
                }
            }
        }
    }
}

