/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Email;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class EmailConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)EmailConstraintTest.webArchiveBuilder().withTestClass(EmailConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="t")})
    public void testNotBlankConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        EmailDummyEntity foo = new EmailDummyEntity();
        Set constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        foo.email = "4 8";
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, Email.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("email"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="t")})
    public void testNotBlankConstraintOnStringBuilder() {
        Validator validator = TestUtil.getValidatorUnderTest();
        EmailStringBuilderDummyEntity foo = new EmailStringBuilderDummyEntity();
        Set constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        foo.email = new StringBuilder("4 8");
        constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, Email.class);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("email"));
    }

    private class EmailStringBuilderDummyEntity {
        @Email
        private StringBuilder email;

        private EmailStringBuilderDummyEntity() {
        }
    }

    private class EmailDummyEntity {
        @Email
        private String email;

        private EmailDummyEntity() {
        }
    }
}

