/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class NotEmptyConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NotEmptyConstraintTest.webArchiveBuilder().withTestClass(NotEmptyConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints", id="r")})
    public void testNotEmptyConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NotEmptyDummyEntity dummy = new NotEmptyDummyEntity();
        dummy.collection = new HashSet();
        dummy.string = "";
        dummy.stringBuilder = new StringBuilder();
        dummy.map = new HashMap();
        NotEmptyDummyEntity.access$502(dummy, new Integer[0]);
        NotEmptyDummyEntity.access$602(dummy, new boolean[0]);
        NotEmptyDummyEntity.access$702(dummy, new byte[0]);
        NotEmptyDummyEntity.access$802(dummy, new char[0]);
        NotEmptyDummyEntity.access$902(dummy, new double[0]);
        NotEmptyDummyEntity.access$1002(dummy, new float[0]);
        NotEmptyDummyEntity.access$1102(dummy, new int[0]);
        NotEmptyDummyEntity.access$1202(dummy, new long[0]);
        NotEmptyDummyEntity.access$1302(dummy, new short[0]);
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("collection"), ConstraintViolationAssert.pathWith().property("map"), ConstraintViolationAssert.pathWith().property("string"), ConstraintViolationAssert.pathWith().property("stringBuilder"), ConstraintViolationAssert.pathWith().property("integerArray"), ConstraintViolationAssert.pathWith().property("booleanArray"), ConstraintViolationAssert.pathWith().property("byteArray"), ConstraintViolationAssert.pathWith().property("charArray"), ConstraintViolationAssert.pathWith().property("doubleArray"), ConstraintViolationAssert.pathWith().property("floatArray"), ConstraintViolationAssert.pathWith().property("intArray"), ConstraintViolationAssert.pathWith().property("longArray"), ConstraintViolationAssert.pathWith().property("shortArray"));
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class, NotEmpty.class);
        dummy.collection.add("foo");
        dummy.string = "a";
        dummy.stringBuilder.append("a");
        dummy.map.put("key1", "value1");
        NotEmptyDummyEntity.access$502(dummy, new Integer[1]);
        NotEmptyDummyEntity.access$602(dummy, new boolean[1]);
        NotEmptyDummyEntity.access$702(dummy, new byte[1]);
        NotEmptyDummyEntity.access$802(dummy, new char[1]);
        NotEmptyDummyEntity.access$902(dummy, new double[1]);
        NotEmptyDummyEntity.access$1002(dummy, new float[1]);
        NotEmptyDummyEntity.access$1102(dummy, new int[1]);
        NotEmptyDummyEntity.access$1202(dummy, new long[1]);
        NotEmptyDummyEntity.access$1302(dummy, new short[1]);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    private static class NotEmptyDummyEntity {
        @NotEmpty
        private String string;
        @NotEmpty
        private StringBuilder stringBuilder;
        @NotEmpty
        private Collection<String> collection;
        @NotEmpty
        private Map<String, String> map;
        @NotEmpty
        private Integer[] integerArray;
        @NotEmpty
        private boolean[] booleanArray;
        @NotEmpty
        private byte[] byteArray;
        @NotEmpty
        private char[] charArray;
        @NotEmpty
        private double[] doubleArray;
        @NotEmpty
        private float[] floatArray;
        @NotEmpty
        private int[] intArray;
        @NotEmpty
        private long[] longArray;
        @NotEmpty
        private short[] shortArray;

        private NotEmptyDummyEntity() {
        }

        static /* synthetic */ Integer[] access$502(NotEmptyDummyEntity x0, Integer[] x1) {
            x0.integerArray = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$602(NotEmptyDummyEntity x0, boolean[] x1) {
            x0.booleanArray = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$702(NotEmptyDummyEntity x0, byte[] x1) {
            x0.byteArray = x1;
            return x1;
        }

        static /* synthetic */ char[] access$802(NotEmptyDummyEntity x0, char[] x1) {
            x0.charArray = x1;
            return x1;
        }

        static /* synthetic */ double[] access$902(NotEmptyDummyEntity x0, double[] x1) {
            x0.doubleArray = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1002(NotEmptyDummyEntity x0, float[] x1) {
            x0.floatArray = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1102(NotEmptyDummyEntity x0, int[] x1) {
            x0.intArray = x1;
            return x1;
        }

        static /* synthetic */ long[] access$1202(NotEmptyDummyEntity x0, long[] x1) {
            x0.longArray = x1;
            return x1;
        }

        static /* synthetic */ short[] access$1302(NotEmptyDummyEntity x0, short[] x1) {
            x0.shortArray = x1;
            return x1;
        }
    }
}

