/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import javax.validation.ConstraintDeclarationException;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.model.Order;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.model.Person;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.AbstractCalendarService;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ExtendedOrderServiceImplementation;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationAddingParameterConstraints;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationMarkingParameterAsCascaded;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfCascadingAndNonCascadingInterfaces;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfCascadingInterfaceExtendingUncascadingSuperClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfConstrainedAndUnconstrainedInterfaces;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.ImplementationOfConstrainedInterfaceExtendingUnconstrainedSuperClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.OrderServiceImplementation;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.OrderServiceSubClass;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.SubClassAddingParameterConstraints;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.method.invaliddeclarations.service.impl.SubClassMarkingParameterAsCascaded;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class InvalidMethodConstraintDeclarationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)InvalidMethodConstraintDeclarationTest.webArchiveBuilder().withTestClassPackage(InvalidMethodConstraintDeclarationTest.class)).withPackage(ImplementationAddingParameterConstraints.class.getPackage())).withPackage(AbstractCalendarService.class.getPackage())).withPackage(Person.class.getPackage())).build();
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterConstraintsAddedInInterfaceImplementationCausesException() throws Exception {
        ImplementationAddingParameterConstraints object = new ImplementationAddingParameterConstraints();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Implementing method must add no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterConstraintsAddedInSubClassCausesException() throws Exception {
        SubClassAddingParameterConstraints object = new SubClassAddingParameterConstraints();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Overriding subclass method must add no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterMarkedAsCascadedInInterfaceImplementationCausesException() throws Exception {
        ImplementationMarkingParameterAsCascaded object = new ImplementationMarkingParameterAsCascaded();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Implementing method must not mark a parameter cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterMarkedAsCascadedInSubClassCausesException() throws Exception {
        SubClassMarkingParameterAsCascaded object = new SubClassMarkingParameterAsCascaded();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Overriding subclass method must not mark a parameter cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testConstrainedParameterInOneMethodOfParallelInterfacesCausesException() throws Exception {
        ImplementationOfConstrainedAndUnconstrainedInterfaces object = new ImplementationOfConstrainedAndUnconstrainedInterfaces();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in two parallel interfaces must have no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterIsConstrainedInInterfaceMethodAndSuperClassMethodCausesException() throws Exception {
        ImplementationOfConstrainedInterfaceExtendingUnconstrainedSuperClass object = new ImplementationOfConstrainedInterfaceExtendingUnconstrainedSuperClass();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in an interface and a superclass not implementing this interface must have no parameter constraints. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterIsCascadingInOneMethodOfParallelInterfacesCausesException() throws Exception {
        ImplementationOfCascadingAndNonCascadingInterfaces object = new ImplementationOfCascadingAndNonCascadingInterfaces();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in two parallel interfaces must not have no parameters marked as cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testParameterIsCascadingInInterfaceMethodAndSuperClassMethodCausesException() throws Exception {
        ImplementationOfCascadingInterfaceExtendingUncascadingSuperClass object = new ImplementationOfCascadingInterfaceExtendingUncascadingSuperClass();
        Method method = this.getCreateEventMethod(object);
        Object[] parameterValues = new Object[3];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A method defined in an interface and a superclass not implementing this interface must have no parameters marked as cascaded. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testReturnValueIsMarkedAsCascadedInInterfaceAndImplementationCausesException() throws Exception {
        OrderServiceImplementation object = new OrderServiceImplementation();
        Method method = this.getPlaceOrderMethod(object);
        Order returnValue = new Order();
        this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.fail((String)"A method must not mark the return value as cascaded if the implemented interface method is cascaded, too. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testReturnValueIsMarkedAsCascadedInBaseAndSubClassCausesException() throws Exception {
        OrderServiceSubClass object = new OrderServiceSubClass();
        Method method = this.getPlaceOrderMethod(object);
        Order returnValue = new Order();
        this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.fail((String)"A method must not mark the return value as cascaded if the overridden superclass method is cascaded, too. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-methodlevelconstraints-inheritance", id="e")})
    public void testReturnValueIsMarkedAsCascadedInSuperAndDerivedInterfaceCausesException() throws Exception {
        ExtendedOrderServiceImplementation object = new ExtendedOrderServiceImplementation();
        Method method = this.getPlaceOrderMethod(object);
        Order returnValue = new Order();
        this.getExecutableValidator().validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        Assert.fail((String)"An interface method must not mark the return value as cascaded if the overridden superinterface method is cascaded, too. Expected exception wasn't thrown.");
    }

    private Method getCreateEventMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("createEvent", Date.class, Date.class, List.class);
    }

    private Method getPlaceOrderMethod(Object object) throws NoSuchMethodException {
        return object.getClass().getMethod("placeOrder", String.class, Integer.TYPE);
    }
}

