/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.defaultinjection;

import java.util.Set;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.defaultinjection.ConstantMessageInterpolator;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class DefaultInjectionTest
extends AbstractTCKTest {
    @Inject
    private ValidatorFactory defaultValidatorFactory;
    @Inject
    @Default
    private ValidatorFactory qualifiedDefaultValidatorFactory;
    @Inject
    private Validator defaultValidator;
    @Inject
    @Default
    private Validator qualifiedDefaultValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)DefaultInjectionTest.webArchiveBuilder().withTestClassPackage(DefaultInjectionTest.class)).withValidationXml("validation-DefaultInjectionTest.xml")).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="a"), @SpecAssertion(section="integration-general-objectslifecycle", id="b"), @SpecAssertion(section="integration-cdi-validatorfactory", id="a"), @SpecAssertion(section="integration-cdi", id="a")})
    public void testDefaultValidatorFactoryGetsInjected() {
        Assert.assertNotNull((Object)this.defaultValidatorFactory, (String)"Default validator factory should be injectable.");
        Assert.assertTrue((boolean)(this.defaultValidatorFactory.getMessageInterpolator() instanceof ConstantMessageInterpolator), (String)"Injected default validator factory should be configured based on META-INF/validation.xml.");
        Set violations = this.defaultValidatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Invalid constraint");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="a"), @SpecAssertion(section="integration-general-objectslifecycle", id="b"), @SpecAssertion(section="integration-cdi-validatorfactory", id="a")})
    public void testQualifiedDefaultValidatorFactoryGetsInjected() {
        Assert.assertNotNull((Object)this.qualifiedDefaultValidatorFactory, (String)"Qualified default validator factory should be injectable.");
        Assert.assertTrue((boolean)(this.qualifiedDefaultValidatorFactory.getMessageInterpolator() instanceof ConstantMessageInterpolator), (String)"Injected qualified default validator factory should be configured based on META-INF/validation.xml.");
        Set violations = this.qualifiedDefaultValidatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Invalid constraint");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="a"), @SpecAssertion(section="integration-general-objectslifecycle", id="b"), @SpecAssertion(section="integration-cdi-validatorfactory", id="a"), @SpecAssertion(section="integration-cdi", id="a")})
    public void testDefaultValidatorGetsInjected() {
        Assert.assertNotNull((Object)this.defaultValidator, (String)"Default validator should be injectable.");
        Set violations = this.defaultValidator.validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Invalid constraint");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="a"), @SpecAssertion(section="integration-general-objectslifecycle", id="b"), @SpecAssertion(section="integration-cdi-validatorfactory", id="a")})
    public void testQualifiedDefaultValidatorGetsInjected() {
        Assert.assertNotNull((Object)this.qualifiedDefaultValidator, (String)"Qualified default validator should be injectable.");
        Set violations = this.qualifiedDefaultValidator.validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Invalid constraint");
    }

    private static class Foo {
        @NotNull
        public String bar;

        private Foo() {
        }
    }
}

