/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.factory;

import java.util.Set;
import javax.inject.Inject;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.factory.GreetingConstraint;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstraintValidatorInjectionTest
extends AbstractTCKTest {
    @Inject
    private ValidatorFactory defaultValidatorFactory;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ConstraintValidatorInjectionTest.webArchiveBuilder().withTestClassPackage(ConstraintValidatorInjectionTest.class)).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-objectslifecycle", id="c"), @SpecAssertion(section="integration-cdi", id="a"), @SpecAssertion(section="integration-cdi-customconfiguration", id="b")})
    public void testDependencyInjectionIntoConstraintValidator() {
        Set violations = this.defaultValidatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Hello, Mr. bar!", "Good morning, Mr. qux!");
    }

    private static class Foo {
        @GreetingConstraint(name="bar")
        public String bar;
        @GreetingConstraint(name="qux")
        public Integer qux;

        private Foo() {
        }
    }
}

