/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.CrossParameterDescriptor;
import javax.validation.metadata.Scope;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerServiceExtension;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class CrossParameterDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)CrossParameterDescriptorTest.webArchiveBuilder().withTestClass(CrossParameterDescriptorTest.class)).withClasses(Account.class, Customer.class, CustomerService.class, CustomerServiceExtension.class, Executables.class, Person.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-crossparameterdescriptor", id="a")})
    public void testGetElementClass() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedMethod().getCrossParameterDescriptor();
        Assert.assertEquals((Object)descriptor.getElementClass(), Object[].class);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="c")
    public void testHasConstraintsForMethod() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedMethod().getCrossParameterDescriptor();
        Assert.assertTrue((boolean)descriptor.hasConstraints(), (String)"Should have constraints");
    }

    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="c")
    public void testHasConstraintsForUnconstrainedMethod() {
        CrossParameterDescriptor descriptor = Executables.unconstrainedMethod().getCrossParameterDescriptor();
        Assert.assertFalse((boolean)descriptor.hasConstraints(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="c")
    public void testHasConstraintsForConstructor() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedConstructor().getCrossParameterDescriptor();
        Assert.assertTrue((boolean)descriptor.hasConstraints(), (String)"Should have constraints");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="c")
    public void testHasConstraintsForConstructorWithoutCrossParameterConstraints() {
        CrossParameterDescriptor descriptor = Executables.returnValueConstrainedConstructor().getCrossParameterDescriptor();
        Assert.assertFalse((boolean)descriptor.hasConstraints(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-constraintdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-elementdescriptor", id="b"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testGetConstraintsForMethod() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedMethod().getCrossParameterDescriptor();
        Set constraints = descriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)1, (String)"Should have constraints");
        ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.iterator().next();
        Assert.assertEquals(constraint.getAnnotation().annotationType(), CustomerService.MyCrossParameterConstraint.class, (String)"Wrong constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="b"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testGetConstraintsForMethodWithoutCrossParameterConstraints() {
        CrossParameterDescriptor descriptor = Executables.returnValueConstrainedMethod().getCrossParameterDescriptor();
        Set constraints = descriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)0, (String)"Should have no constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="b"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testGetConstraintsForConstructor() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedConstructor().getCrossParameterDescriptor();
        Set constraints = descriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)1, (String)"Should have constraints");
        ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.iterator().next();
        Assert.assertEquals(constraint.getAnnotation().annotationType(), CustomerService.MyCrossParameterConstraint.class, (String)"Wrong constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="b"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testGetConstraintsForConstructorWithoutCrossParameterConstraints() {
        CrossParameterDescriptor descriptor = Executables.returnValueConstrainedConstructor().getCrossParameterDescriptor();
        Set constraints = descriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)0, (String)"Should have no constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testFindConstraintsForMethod() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedMethod().getCrossParameterDescriptor();
        Set constraints = descriptor.findConstraints().getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)1, (String)"Should have constraints");
        ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.iterator().next();
        Assert.assertEquals(constraint.getAnnotation().annotationType(), CustomerService.MyCrossParameterConstraint.class, (String)"Wrong constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="g"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testFindConstraintsForMethodLookingAt() {
        CrossParameterDescriptor descriptor = Executables.methodOverridingCrossParameterConstrainedMethod().getCrossParameterDescriptor();
        Set constraints = descriptor.findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)0, (String)"Should have no local constraints");
        constraints = descriptor.findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)1, (String)"Should have constraints");
        ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.iterator().next();
        Assert.assertEquals(constraint.getAnnotation().annotationType(), CustomerService.MyCrossParameterConstraint.class, (String)"Wrong constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="g"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testFindConstraintsForMethodDefinedOnSuperTypeLookingAt() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedMethodFromSuperType().getCrossParameterDescriptor();
        Set constraints = descriptor.findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)0, (String)"Should have no local constraints");
        constraints = descriptor.findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)1, (String)"Should have constraints");
        ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.iterator().next();
        Assert.assertEquals(constraint.getAnnotation().annotationType(), CustomerService.MyCrossParameterConstraint.class, (String)"Wrong constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testFindConstraintsForMethodWithoutCrossParameterConstraints() {
        CrossParameterDescriptor descriptor = Executables.returnValueConstrainedMethod().getCrossParameterDescriptor();
        Set constraints = descriptor.findConstraints().getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)0, (String)"Should have no constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testFindConstraintsForConstructor() {
        CrossParameterDescriptor descriptor = Executables.crossParameterConstrainedConstructor().getCrossParameterDescriptor();
        Set constraints = descriptor.findConstraints().getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)1, (String)"Should have constraints");
        ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.iterator().next();
        Assert.assertEquals(constraint.getAnnotation().annotationType(), CustomerService.MyCrossParameterConstraint.class, (String)"Wrong constraint type");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-executabledescriptor", id="c")})
    public void testFindConstraintsForConstructorWithoutCrossParameterConstraints() {
        CrossParameterDescriptor descriptor = Executables.returnValueConstrainedConstructor().getCrossParameterDescriptor();
        Set constraints = descriptor.findConstraints().getConstraintDescriptors();
        Assert.assertEquals((int)constraints.size(), (int)0, (String)"Should have no constraints");
    }
}

