/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.List;
import java.util.Set;
import javax.validation.groups.Default;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ParameterDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ParameterDescriptorTest.webArchiveBuilder().withTestClass(ParameterDescriptorTest.class)).withClasses(Account.class, Customer.class, CustomerService.class, Executables.class, Person.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertEquals((Object)((ParameterDescriptor)parameters.get(0)).getElementClass(), String.class, (String)"Wrong parameter class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertEquals((Object)((ParameterDescriptor)parameters.get(0)).getElementClass(), String.class, (String)"Wrong parameter class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="a")
    public void testGetIndexForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(0)).getIndex(), (int)0, (String)"Wrong parameter index");
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(1)).getIndex(), (int)1, (String)"Wrong parameter index");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="a")
    public void testGetIndexForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(0)).getIndex(), (int)0, (String)"Wrong parameter index");
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(1)).getIndex(), (int)1, (String)"Wrong parameter index");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="b")
    public void testGetNameForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(0)).getName(), (String)"firstName", (String)"Wrong parameter name");
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(1)).getName(), (String)"lastName", (String)"Wrong parameter name");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="b")
    public void testGetNameForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(0)).getName(), (String)"firstName", (String)"Wrong parameter name");
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(1)).getName(), (String)"lastName", (String)"Wrong parameter name");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertFalse((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should not be cascaded");
        parameters = Executables.cascadedParameterMethod().getParameterDescriptors();
        Assert.assertTrue((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertFalse((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should not be cascaded");
        parameters = Executables.cascadedParameterConstructor().getParameterDescriptors();
        Assert.assertTrue((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForConstructorParameter() {
        List parameters = Executables.constructorWithGroupConversionOnParameter().getParameterDescriptors();
        Set groupConversions = ((ParameterDescriptor)parameters.get(1)).getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForMethodParameter() {
        List parameters = Executables.methodWithGroupConversionOnParameter().getParameterDescriptors();
        Set groupConversions = ((ParameterDescriptor)parameters.get(0)).getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForConstructorParameter() {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)Executables.parameterConstrainedConstructor().getParameterDescriptors().get(0);
        Set groupConversions = parameterDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForMethodParameter() {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)Executables.parameterConstrainedMethod().getParameterDescriptors().get(0);
        Set groupConversions = parameterDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }
}

