/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.testng.Assert;

public final class ConstraintViolationAssert {
    public static final String BEAN_NODE_NAME = null;
    public static final String CROSS_PARAMETER_NODE_NAME = "<cross-parameter>";
    public static final String RETURN_VALUE_NODE_NAME = "<return value>";

    private ConstraintViolationAssert() {
    }

    public static void assertCorrectConstraintViolationMessages(Set<? extends ConstraintViolation<?>> violations, String ... expectedMessages) {
        ArrayList<String> actualMessages = new ArrayList<String>();
        for (ConstraintViolation<?> violation : violations) {
            actualMessages.add(violation.getMessage());
        }
        Assertions.assertThat(actualMessages).containsOnly((Object[])expectedMessages);
    }

    public static void assertCorrectConstraintViolationMessages(ConstraintViolationException e, String ... expectedMessages) {
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(e.getConstraintViolations(), expectedMessages);
    }

    public static void assertCorrectConstraintTypes(Set<? extends ConstraintViolation<?>> violations, Class<?> ... expectedConstraintTypes) {
        ArrayList<Class<? extends Annotation>> actualConstraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintViolation<?> violation : violations) {
            actualConstraintTypes.add(violation.getConstraintDescriptor().getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static ConstraintViolationSetAssert assertThat(Set<? extends ConstraintViolation<?>> actualViolations) {
        return new ConstraintViolationSetAssert(actualViolations);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, Class<?> rootBeanClass, Object invalidValue, PathExpectation propertyPath) {
        Assertions.assertThat((Object)new PathExpectation(violation.getPropertyPath())).isEqualTo((Object)propertyPath);
        ConstraintViolationAssert.assertConstraintViolation(violation, rootBeanClass, invalidValue);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, Class<?> rootBeanClass, Object invalidValue) {
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)invalidValue, (String)"Wrong invalid value");
        ConstraintViolationAssert.assertConstraintViolation(violation, rootBeanClass);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, Class<?> rootBeanClass) {
        Assert.assertEquals((Object)violation.getRootBeanClass(), rootBeanClass, (String)"Wrong root bean type");
    }

    public static void assertNumberOfViolations(Set<? extends ConstraintViolation<?>> violations, int numberOfViolations) {
        Assert.assertEquals((int)violations.size(), (int)numberOfViolations, (String)"Wrong number of constraint violations");
    }

    public static void assertConstraintTypes(Set<? extends ConstraintDescriptor<?>> descriptors, Class<?> ... expectedConstraintTypes) {
        ArrayList<Class<? extends Annotation>> actualConstraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintDescriptor<?> descriptor : descriptors) {
            actualConstraintTypes.add(descriptor.getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static boolean pathsAreEqual(Path p1, Path p2) {
        if (p1 == null) {
            return p2 == null;
        }
        return ConstraintViolationAssert.pathsAreEqual(new PathExpectation(p1), new PathExpectation(p2));
    }

    public static boolean pathsAreEqual(Path p1, PathExpectation p2) {
        if (p1 == null) {
            return p2 == null;
        }
        return ConstraintViolationAssert.pathsAreEqual(new PathExpectation(p1), p2);
    }

    public static boolean pathsAreEqual(PathExpectation p1, PathExpectation p2) {
        if (p1 == null) {
            return p2 == null;
        }
        return p1.equals(p2);
    }

    private static <T> void assertCorrectConstraintTypes(Iterable<Class<? extends Annotation>> actualConstraintTypes, Class<?> ... expectedConstraintTypes) {
        ArrayList<String> expectedConstraintTypeNames = new ArrayList<String>();
        for (Class<?> expectedConstraintType : expectedConstraintTypes) {
            expectedConstraintTypeNames.add(expectedConstraintType.getName());
        }
        ArrayList<String> actualConstraintTypeNames = new ArrayList<String>();
        for (Class<? extends Annotation> actualConstraintType : actualConstraintTypes) {
            actualConstraintTypeNames.add(actualConstraintType.getName());
        }
        Collections.sort(expectedConstraintTypeNames);
        Collections.sort(actualConstraintTypeNames);
        Assert.assertEquals(actualConstraintTypeNames, expectedConstraintTypeNames, (String)String.format("Expected %s, but got %s", expectedConstraintTypeNames, actualConstraintTypeNames));
    }

    public static PathExpectation pathWith() {
        return new PathExpectation();
    }

    private static Class<?> getContainerClass(Path.Node node) {
        Class containerClass = null;
        if (node.getKind() == ElementKind.PROPERTY) {
            containerClass = ((Path.PropertyNode)node.as(Path.PropertyNode.class)).getContainerClass();
        }
        if (node.getKind() == ElementKind.BEAN) {
            containerClass = ((Path.BeanNode)node.as(Path.BeanNode.class)).getContainerClass();
        }
        if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
            containerClass = ((Path.ContainerElementNode)node.as(Path.ContainerElementNode.class)).getContainerClass();
        }
        return containerClass;
    }

    private static Integer getTypeArgumentIndex(Path.Node node) {
        Integer typeArgumentIndex = null;
        if (node.getKind() == ElementKind.PROPERTY) {
            typeArgumentIndex = ((Path.PropertyNode)node.as(Path.PropertyNode.class)).getTypeArgumentIndex();
        }
        if (node.getKind() == ElementKind.BEAN) {
            typeArgumentIndex = ((Path.BeanNode)node.as(Path.BeanNode.class)).getTypeArgumentIndex();
        }
        if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
            typeArgumentIndex = ((Path.ContainerElementNode)node.as(Path.ContainerElementNode.class)).getTypeArgumentIndex();
        }
        return typeArgumentIndex;
    }

    private static class NodeExpectation {
        private final String name;
        private final ElementKind kind;
        private final boolean inIterable;
        private final Object key;
        private final Integer index;
        private final Integer parameterIndex;
        private final Class<?> containerClass;
        private final Integer typeArgumentIndex;

        private NodeExpectation(String name, ElementKind kind) {
            this(name, kind, false, null, null, null, null, null);
        }

        private NodeExpectation(String name, ElementKind kind, boolean inIterable, Object key, Integer index, Integer parameterIndex, Class<?> containerClass, Integer typeArgumentIndex) {
            this.name = name;
            this.kind = kind;
            this.inIterable = inIterable;
            this.key = key;
            this.index = index;
            this.parameterIndex = parameterIndex;
            this.containerClass = containerClass;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public String toString() {
            return "NodeExpectation(" + this.name + ", " + this.kind + ", " + this.inIterable + ", " + this.key + ", " + this.index + ", " + this.parameterIndex + ", " + this.containerClass + ", " + this.typeArgumentIndex + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inIterable ? 1231 : 1237);
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
            result = 31 * result + (this.containerClass == null ? 0 : this.containerClass.hashCode());
            result = 31 * result + (this.typeArgumentIndex == null ? 0 : this.typeArgumentIndex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeExpectation other = (NodeExpectation)obj;
            if (this.inIterable != other.inIterable) {
                return false;
            }
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex)) {
                return false;
            }
            if (this.containerClass == null ? other.containerClass != null : !this.containerClass.equals(other.containerClass)) {
                return false;
            }
            return !(this.typeArgumentIndex == null ? other.typeArgumentIndex != null : !this.typeArgumentIndex.equals(other.typeArgumentIndex));
        }
    }

    public static class PathExpectation {
        private final List<NodeExpectation> nodes = new ArrayList<NodeExpectation>();

        private PathExpectation() {
        }

        private PathExpectation(Path propertyPath) {
            for (Path.Node node : propertyPath) {
                Integer parameterIndex = null;
                if (node.getKind() == ElementKind.PARAMETER) {
                    parameterIndex = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                }
                Class containerClass = ConstraintViolationAssert.getContainerClass(node);
                Integer typeArgumentIndex = ConstraintViolationAssert.getTypeArgumentIndex(node);
                this.nodes.add(new NodeExpectation(node.getName(), node.getKind(), node.isInIterable(), node.getKey(), node.getIndex(), parameterIndex, containerClass, typeArgumentIndex));
            }
        }

        public PathExpectation property(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY));
            return this;
        }

        public PathExpectation property(String name, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, false, null, null, null, containerClass, typeArgumentIndex));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null, null, null));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null, containerClass, typeArgumentIndex));
            return this;
        }

        public PathExpectation bean() {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null, null, null));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null, containerClass, typeArgumentIndex));
            return this;
        }

        public PathExpectation constructor(Class<?> clazz) {
            this.nodes.add(new NodeExpectation(clazz.getSimpleName(), ElementKind.CONSTRUCTOR));
            return this;
        }

        public PathExpectation method(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.METHOD));
            return this;
        }

        public PathExpectation parameter(String name, int index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PARAMETER, false, null, null, index, null, null));
            return this;
        }

        public PathExpectation crossParameter() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.CROSS_PARAMETER_NODE_NAME, ElementKind.CROSS_PARAMETER));
            return this;
        }

        public PathExpectation returnValue() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.RETURN_VALUE_NODE_NAME, ElementKind.RETURN_VALUE));
            return this;
        }

        public PathExpectation containerElement(String name, boolean inIterable, Object key, Integer index, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(name, ElementKind.CONTAINER_ELEMENT, inIterable, key, index, null, containerClass, typeArgumentIndex));
            return this;
        }

        public String toString() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder(lineBreak + "PathExpectation(" + lineBreak);
            for (NodeExpectation node : this.nodes) {
                asString.append("  ").append(node).append(lineBreak);
            }
            return asString.append(")").toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathExpectation other = (PathExpectation)obj;
            return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
        }
    }

    public static class ConstraintViolationSetAssert
    extends IterableAssert<ConstraintViolation<?>> {
        protected ConstraintViolationSetAssert(Set<? extends ConstraintViolation<?>> actualViolations) {
            super(actualViolations);
        }

        public void containsOnlyPaths(PathExpectation ... paths) {
            this.isNotNull();
            ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
            for (ConstraintViolation violation : (Iterable)this.actual) {
                actualPaths.add(new PathExpectation(violation.getPropertyPath()));
            }
            Assertions.assertThat(actualPaths).containsOnly((Object[])paths);
        }

        public void containsPath(PathExpectation expectedPath) {
            this.isNotNull();
            ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
            for (ConstraintViolation violation : (Iterable)this.actual) {
                PathExpectation actual = new PathExpectation(violation.getPropertyPath());
                if (actual.equals(expectedPath)) {
                    return;
                }
                actualPaths.add(actual);
            }
            Assert.fail((String)String.format("Didn't find path <%s> in actual paths <%s>.", expectedPath, actualPaths));
        }

        public void containsPaths(PathExpectation ... expectedPaths) {
            for (PathExpectation pathExpectation : expectedPaths) {
                this.containsPath(pathExpectation);
            }
        }
    }
}

