/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.spi.ValidationProvider;
import org.testng.Assert;

public final class TestUtil {
    private static final String VALIDATION_PROVIDER_TEST_CLASS = "validation.provider";
    private static ValidationProvider<?> validationProviderUnderTest;

    private TestUtil() {
    }

    public static Validator getValidatorUnderTest() {
        return TestUtil.getValidatorFactoryUnderTest().getValidator();
    }

    public static ValidationProvider<?> getValidationProviderUnderTest() {
        if (validationProviderUnderTest == null) {
            TestUtil.instantiateValidationProviderUnderTest();
        }
        return validationProviderUnderTest;
    }

    public static ValidatorFactory getValidatorFactoryUnderTest() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        return config.buildValidatorFactory();
    }

    public static Configuration<?> getConfigurationUnderTest() {
        if (validationProviderUnderTest == null) {
            TestUtil.instantiateValidationProviderUnderTest();
        }
        ProviderSpecificBootstrap bootstrap = Validation.byProvider(validationProviderUnderTest.getClass());
        return bootstrap.configure();
    }

    public static MessageInterpolator getDefaultMessageInterpolator() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        return config.getDefaultMessageInterpolator();
    }

    public static Set<String> getParameterNames(Set<? extends ConstraintViolation<?>> constraintViolations) {
        HashSet<String> parameterNames = new HashSet<String>();
        for (ConstraintViolation<?> constraintViolation : constraintViolations) {
            parameterNames.add(TestUtil.getParameterName(constraintViolation.getPropertyPath()));
        }
        return parameterNames;
    }

    public static <T> ConstraintViolation<T> getConstraintViolationForParameter(Set<ConstraintViolation<T>> constraintViolations, String parameterName) {
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            if (!parameterName.equals(TestUtil.getParameterName(constraintViolation.getPropertyPath()))) continue;
            return constraintViolation;
        }
        throw new IllegalArgumentException("Found no constraint violation for parameter " + parameterName);
    }

    public static <T> ConstraintViolation<T> getConstraintViolationForConstraintType(Set<ConstraintViolation<T>> constraintViolations, Class<? extends Annotation> constraint) {
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            if (!constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().equals(constraint)) continue;
            return constraintViolation;
        }
        throw new IllegalArgumentException("Found no constraint violation for constraint " + constraint.getSimpleName());
    }

    public static String getParameterName(Path path) {
        Iterator nodes = path.iterator();
        Assert.assertTrue((boolean)nodes.hasNext());
        nodes.next();
        Assert.assertTrue((boolean)nodes.hasNext());
        return ((Path.Node)nodes.next()).getName();
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return validator.getConstraintsForClass(clazz).getConstraintsForProperty(property);
    }

    public static MethodDescriptor getMethodDescriptor(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return validator.getConstraintsForClass(clazz).getConstraintsForMethod(name, (Class[])parameterTypes);
    }

    public static ConstructorDescriptor getConstructorDescriptor(Class<?> clazz, Class<?> ... parameterTypes) {
        Validator validator = TestUtil.getValidatorUnderTest();
        return validator.getConstraintsForClass(clazz).getConstraintsForConstructor((Class[])parameterTypes);
    }

    public static Set<ConstraintDescriptor<?>> getConstraintDescriptorsFor(Class<?> clazz, String property) {
        PropertyDescriptor elementDescriptor = TestUtil.getPropertyDescriptor(clazz, property);
        return elementDescriptor.getConstraintDescriptors();
    }

    public static InputStream getInputStreamForPath(String path) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            inputStream = TestUtil.class.getResourceAsStream(path);
        }
        return inputStream;
    }

    private static <U extends ValidationProvider<?>> void instantiateValidationProviderUnderTest() {
        Class<?> providerClass;
        String validatorProviderClassName = System.getProperty(VALIDATION_PROVIDER_TEST_CLASS);
        if (validatorProviderClassName == null) {
            throw new RuntimeException("The test harness must specify the class name of the validation provider under test. Set system property 'validation.provider'");
        }
        try {
            Class<?> tmpClazz;
            providerClass = tmpClazz = TestUtil.class.getClassLoader().loadClass(validatorProviderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load " + validatorProviderClassName);
        }
        try {
            validationProviderUnderTest = (ValidationProvider)providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + validatorProviderClassName);
        }
    }
}

