/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.service;

import javax.validation.GroupSequence;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.ConvertGroup;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidRetailOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidRetailOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Order;

public class OrderService {
    @Size(min=6)
    private @Size(min=6) String name;

    public OrderService() {
    }

    public OrderService(String name) {
        this.name = name;
    }

    @MyCrossParameterConstraint
    @ValidOrder
    @Valid
    public Order placeOrder(@NotNull String customer, @Valid Item item, @Min(value=1L) @Min(value=1L) int quantity) {
        return null;
    }

    @MyCrossParameterConstraint
    @ValidOrderService
    @Valid
    public OrderService(@NotNull String customer, @Valid Item item, @Min(value=1L) @Min(value=1L) int quantity) {
    }

    @MyCrossParameterConstraint(groups={Basic.class})
    @ValidOrder
    @ValidRetailOrder(groups={Basic.class})
    @Valid
    public Order placeOrder(@NotNull(groups={Basic.class}) String customer, @Valid Item item, @Min(value=1L) @Min(value=1L) Integer quantity) {
        return null;
    }

    @MyCrossParameterConstraint(groups={Basic.class})
    @ValidOrderService
    @ValidRetailOrderService(groups={Basic.class})
    @Valid
    public OrderService(@NotNull(groups={Basic.class}) String customer, @Valid Item item, @Min(value=1L) @Min(value=1L) Integer quantity) {
    }

    @Valid
    @ConvertGroup(from=Basic.class, to=Default.class)
    public Order placeOrder(String customer, @Valid @ConvertGroup(from=Basic.class, to=Default.class) Item item, long quantity) {
        return null;
    }

    @Valid
    @ConvertGroup(from=Basic.class, to=Default.class)
    public OrderService(String customer, @Valid @ConvertGroup(from=Basic.class, to=Default.class) Item item, long quantity) {
    }

    @MyCrossParameterConstraint(groups={Basic.class, Default.class})
    @ValidOrder(groups={Basic.class, Default.class})
    public Order placeOrder(@NotNull(groups={Basic.class, Default.class}) String customer, @Valid @ConvertGroup(from=Basic.class, to=Item.Basic.class) Item item, @Min(value=1L, groups={Basic.class, Default.class}) @Min(value=1L, groups={Basic.class, Default.class}) short quantity) {
        return null;
    }

    @MyCrossParameterConstraint(groups={Basic.class, Default.class})
    @ValidOrderService(groups={Basic.class, Default.class})
    public OrderService(@NotNull(groups={Basic.class, Default.class}) String customer, @Valid @ConvertGroup(from=Basic.class, to=Item.Basic.class) Item item, @Min(value=1L, groups={Basic.class, Default.class}) @Min(value=1L, groups={Basic.class, Default.class}) short quantity) {
    }

    @MyCrossParameterConstraint(groups={Complex.class})
    @ValidOrder(groups={Basic.class})
    @ValidRetailOrder(groups={Complex.class})
    @Valid
    @ConvertGroup(from=Basic.class, to=Default.class)
    public Order placeOrder(@NotNull(groups={Basic.class}) String customer, @Valid @ConvertGroup(from=Basic.class, to=Default.class) Item item, @Min(value=1L, groups={Complex.class}) @Min(value=1L, groups={Complex.class}) byte quantity) {
        return null;
    }

    @MyCrossParameterConstraint(groups={Complex.class})
    @ValidOrderService(groups={Basic.class})
    @ValidRetailOrderService(groups={Complex.class})
    @Valid
    @ConvertGroup(from=Basic.class, to=Default.class)
    public OrderService(@NotNull(groups={Basic.class}) String customer, @Valid @ConvertGroup(from=Basic.class, to=Default.class) Item item, @Min(value=1L, groups={Complex.class}) @Min(value=1L, groups={Complex.class}) byte quantity) {
    }

    public String getName() {
        return this.name;
    }

    @GroupSequence(value={Basic.class, Complex.class})
    public static interface OrderServiceSequence {
    }

    public static interface Complex {
    }

    public static interface Basic {
    }
}

