/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.builtin;

import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.ReadOnlySetWrapper;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.validation.Validator;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class JavaFXValueExtractorsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)JavaFXValueExtractorsTest.webArchiveBuilder().withTestClass(JavaFXValueExtractorsTest.class)).build();
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="f")
    public void testJavaFXBasicProperties() {
        Set constraintViolations = this.getValidator().validate((Object)new BasicPropertiesEntity(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("stringProperty"), ConstraintViolationAssert.violationOf(Max.class).withProperty("doubleProperty"), ConstraintViolationAssert.violationOf(Min.class).withProperty("integerProperty"), ConstraintViolationAssert.violationOf(AssertTrue.class).withProperty("booleanProperty"));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="g")
    public void testValueExtractionForPropertyList() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ListPropertyEntity.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validate((Object)ListPropertyEntity.invalidList(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("listProperty"));
        constraintViolations = validator.validate((Object)ListPropertyEntity.invalidListElement(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("listProperty").containerElement("<list element>", true, null, 0, ListProperty.class, 0)));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="h")
    public void testValueExtractionForPropertySet() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)SetPropertyEntity.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validate((Object)SetPropertyEntity.invalidSet(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("setProperty"));
        constraintViolations = validator.validate((Object)SetPropertyEntity.invalidSetElement(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("setProperty").containerElement("<iterable element>", true, null, null, SetProperty.class, 0)));
    }

    @Test
    @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="i")
    public void testValueExtractionForPropertyMap() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)MapPropertyEntity.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validate((Object)MapPropertyEntity.invalidMap(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("mapProperty"));
        constraintViolations = validator.validate((Object)MapPropertyEntity.invalidMapKey(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("mapProperty").containerElement("<map key>", true, "app", null, MapProperty.class, 0)));
        constraintViolations = validator.validate((Object)MapPropertyEntity.invalidMapValue(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("mapProperty").containerElement("<map value>", true, "pear", null, MapProperty.class, 1)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="g"), @SpecAssertion(section="valueextractordefinition-builtinvalueextractors", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="f")})
    public void testValueExtractionForListOfStringProperty() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)ListOfStringPropertyEntity.valid(), new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validate((Object)ListOfStringPropertyEntity.invalidListElement(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("listProperty").containerElement("<list element>", true, null, 1, ListProperty.class, 0)).withInvalidValue("Bob"));
    }

    public static class ListOfStringPropertyEntity {
        private final ListProperty<@Size(min=4) StringProperty> listProperty;

        private ListOfStringPropertyEntity(ObservableList<StringProperty> innerList) {
            this.listProperty = new SimpleListProperty(innerList);
        }

        public static ListOfStringPropertyEntity valid() {
            return new ListOfStringPropertyEntity((ObservableList<StringProperty>)FXCollections.observableArrayList((Object[])new StringProperty[]{new SimpleStringProperty("Billy"), new SimpleStringProperty("Bruce")}));
        }

        public static ListOfStringPropertyEntity invalidListElement() {
            return new ListOfStringPropertyEntity((ObservableList<StringProperty>)FXCollections.observableArrayList((Object[])new StringProperty[]{new SimpleStringProperty("Billy"), new SimpleStringProperty("Bob")}));
        }
    }

    public static class MapPropertyEntity {
        @Size(min=3)
        private @Size(min=3) MapProperty<@Size(min=4) String, @NotBlank String> mapProperty = new ReadOnlyMapWrapper();

        private MapPropertyEntity(ObservableMap<String, String> innerMap) {
            this.mapProperty = new ReadOnlyMapWrapper(innerMap);
        }

        public static MapPropertyEntity valid() {
            ObservableMap innerMap = FXCollections.observableHashMap();
            innerMap.put((Object)"apple", (Object)"apple@example.com");
            innerMap.put((Object)"pear", (Object)"pear@example.com");
            innerMap.put((Object)"cherry", (Object)"cherry@example.com");
            return new MapPropertyEntity((ObservableMap<String, String>)innerMap);
        }

        public static MapPropertyEntity invalidMap() {
            return new MapPropertyEntity((ObservableMap<String, String>)FXCollections.observableHashMap());
        }

        public static MapPropertyEntity invalidMapKey() {
            ObservableMap innerMap = FXCollections.observableHashMap();
            innerMap.put((Object)"app", (Object)"apple@example.com");
            innerMap.put((Object)"pear", (Object)"pear@example.com");
            innerMap.put((Object)"cherry", (Object)"cherry@example.com");
            return new MapPropertyEntity((ObservableMap<String, String>)innerMap);
        }

        public static MapPropertyEntity invalidMapValue() {
            ObservableMap innerMap = FXCollections.observableHashMap();
            innerMap.put((Object)"apple", (Object)"apple@example.com");
            innerMap.put((Object)"pear", (Object)" ");
            innerMap.put((Object)"cherry", (Object)"cherry@example.com");
            return new MapPropertyEntity((ObservableMap<String, String>)innerMap);
        }
    }

    public static class SetPropertyEntity {
        @Size(min=3)
        private @Size(min=3) SetProperty<@Size(min=4) String> setProperty;

        private SetPropertyEntity(ObservableSet<String> innerList) {
            this.setProperty = new ReadOnlySetWrapper(innerList);
        }

        public static SetPropertyEntity valid() {
            return new SetPropertyEntity((ObservableSet<String>)FXCollections.observableSet((Object[])new String[]{"apple", "pear", "cherry"}));
        }

        public static SetPropertyEntity invalidSet() {
            return new SetPropertyEntity((ObservableSet<String>)FXCollections.observableSet((Object[])new String[]{"apple"}));
        }

        public static SetPropertyEntity invalidSetElement() {
            return new SetPropertyEntity((ObservableSet<String>)FXCollections.observableSet((Object[])new String[]{"app", "pear", "cherry"}));
        }
    }

    public static class ListPropertyEntity {
        @Size(min=3)
        private @Size(min=3) ListProperty<@Size(min=4) String> listProperty;

        private ListPropertyEntity(ObservableList<String> innerList) {
            this.listProperty = new ReadOnlyListWrapper(innerList);
        }

        public static ListPropertyEntity valid() {
            return new ListPropertyEntity((ObservableList<String>)FXCollections.observableArrayList((Object[])new String[]{"apple", "pear", "cherry"}));
        }

        public static ListPropertyEntity invalidList() {
            return new ListPropertyEntity((ObservableList<String>)FXCollections.observableArrayList((Object[])new String[]{"apple"}));
        }

        public static ListPropertyEntity invalidListElement() {
            return new ListPropertyEntity((ObservableList<String>)FXCollections.observableArrayList((Object[])new String[]{"app", "pear", "cherry"}));
        }
    }

    public class BasicPropertiesEntity {
        @NotNull
        private StringProperty stringProperty = new SimpleStringProperty(null);
        @Max(value=3L)
        private @Max(value=3L) ReadOnlyDoubleWrapper doubleProperty = new ReadOnlyDoubleWrapper(4.5);
        @Min(value=3L)
        private @Min(value=3L) IntegerProperty integerProperty = new SimpleIntegerProperty(2);
        @AssertTrue
        private ReadOnlyBooleanProperty booleanProperty = new SimpleBooleanProperty(false);
    }
}

