/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util.shrinkwrap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;

public abstract class ArchiveBuilder<T extends ArchiveBuilder<T, A>, A extends Archive<A>> {
    private String name;
    private Class<?> testClazz = null;
    protected List<ResourceDescriptor> resources = null;
    protected List<String> packages = null;
    protected List<String> classes = null;
    protected List<ServiceProviderDescriptor> serviceProviders = null;
    protected List<File> additionalJars = null;

    public T withName(String name) {
        this.name = name;
        return this.self();
    }

    public T withServiceProvider(ServiceProviderDescriptor serviceProvider) {
        if (this.serviceProviders == null) {
            this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
        }
        this.serviceProviders.add(serviceProvider);
        return this.self();
    }

    public T withClass(Class<?> clazz) {
        if (this.classes == null) {
            this.classes = new ArrayList<String>();
        }
        this.classes.add(clazz.getName());
        return this.self();
    }

    public T withClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.withClass(clazz);
        }
        return this.self();
    }

    public T withTestClassPackage(Class<?> testClazz) {
        return ((ArchiveBuilder)this.withTestClassDefinition(testClazz)).withPackage(testClazz.getPackage());
    }

    public T withTestClass(Class<?> testClazz) {
        return ((ArchiveBuilder)this.withTestClassDefinition(testClazz)).withClass(testClazz);
    }

    public T withTestClassDefinition(Class<?> testClazz) {
        if (this.testClazz != null) {
            throw new IllegalStateException("Cannot set more than one test class definition!");
        }
        this.testClazz = testClazz;
        return this.self();
    }

    public T withPackage(Package pack) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(pack.getName());
        return this.self();
    }

    public T withResource(String source) {
        return this.withResource(source, null, true);
    }

    public T withResource(String source, boolean useTestPackageToLocateSource) {
        return this.withResource(source, null, useTestPackageToLocateSource);
    }

    public T withResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceDescriptor>();
        }
        this.resources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withValidationXml(String source) {
        return this.withResource(source, "META-INF/validation.xml", true);
    }

    public abstract T withEmptyBeansXml();

    public T withAdditionalJar(String jarPath) {
        if (this.additionalJars == null) {
            this.additionalJars = new ArrayList<File>();
        }
        this.additionalJars.add(new File(jarPath));
        return this.self();
    }

    public abstract T self();

    public A build() {
        if (this.testClazz == null) {
            throw new IllegalStateException("Test class must be set!");
        }
        return this.buildInternal();
    }

    protected abstract A buildInternal();

    protected void processPackages(final ClassContainer<?> archive) {
        if (this.packages == null) {
            return;
        }
        for (String pack : this.packages) {
            URLPackageScanner.Callback callback = new URLPackageScanner.Callback(){

                public void classFound(String className) {
                    archive.addClass(className);
                }
            };
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            URLPackageScanner scanner = URLPackageScanner.newInstance((boolean)false, (ClassLoader)classLoader, (URLPackageScanner.Callback)callback, (String)pack);
            scanner.scanPackage();
        }
    }

    protected void processClasses(ClassContainer<?> archive) {
        if (this.classes == null) {
            return;
        }
        for (String clazz : this.classes) {
            if (this.testClazz.getName().equals(clazz)) continue;
            archive.addClass(clazz);
        }
    }

    protected void processResources(ResourceContainer<?> archive) {
        if (this.resources == null) {
            return;
        }
        for (ResourceDescriptor resource : this.resources) {
            if (resource.getSource() != null) {
                if (resource.getTarget() == null) {
                    archive.addAsResource(resource.getSource());
                    continue;
                }
                archive.addAsResource(resource.getSource(), resource.getTarget());
                continue;
            }
            if (resource.getAsset() == null) continue;
            archive.addAsResource(resource.getAsset(), resource.getTarget());
        }
    }

    protected void processAdditionalJars(LibraryContainer<?> archive) {
        if (this.additionalJars == null) {
            return;
        }
        for (File additionalJar : this.additionalJars) {
            archive.addAsLibrary(additionalJar);
        }
    }

    private String getTestPackagePath() {
        return this.testClazz.getPackage().getName().replace('.', '/').concat("/");
    }

    public String getName() {
        return this.name;
    }

    protected class ResourceDescriptor {
        private final Asset asset;
        private final String source;
        private final String target;
        private final boolean useTestPackageToLocateSource;

        public ResourceDescriptor(String source, String target, boolean useTestPackageToLocateSource) {
            this.asset = null;
            this.source = source;
            this.target = target;
            this.useTestPackageToLocateSource = useTestPackageToLocateSource;
        }

        public ResourceDescriptor(Asset asset, String target) {
            this.asset = asset;
            this.source = null;
            this.target = target;
            this.useTestPackageToLocateSource = false;
        }

        public Asset getAsset() {
            return this.asset;
        }

        public String getSource() {
            return this.useTestPackageToLocateSource ? ArchiveBuilder.this.getTestPackagePath() + this.source : this.source;
        }

        public String getPlainSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    protected class ServiceProviderDescriptor {
        private final Class<?> serviceInterface;
        private final Class<?>[] serviceImplementations;

        public ServiceProviderDescriptor(Class<?> serviceInterface, Class<?> ... serviceImplementations) {
            this.serviceInterface = serviceInterface;
            this.serviceImplementations = serviceImplementations;
        }

        public Class<?> getServiceInterface() {
            return this.serviceInterface;
        }

        public Class<?>[] getServiceImplementations() {
            return this.serviceImplementations;
        }
    }
}

