/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.upload;

import org.gradle.api.Action;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.tasks.Upload;
import org.hibernate.build.gradle.upload.AuthenticationProvider;
import org.hibernate.build.gradle.upload.AuthenticationProviderRegistry;
import org.hibernate.build.gradle.upload.MavenAuthentication;
import org.hibernate.build.gradle.upload.MavenRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationHandler
implements Action<Upload> {
    private final AuthenticationProviderRegistry authenticationProviderRegistry;

    public AuthenticationHandler(AuthenticationProviderRegistry authenticationProviderRegistry) {
        this.authenticationProviderRegistry = authenticationProviderRegistry;
    }

    public void execute(Upload upload) {
        upload.getRepositories().withType(MavenDeployer.class).all((Action)new Action<MavenDeployer>(){

            public void execute(MavenDeployer deployer) {
                MavenRepository snapshotRepository;
                MavenAuthentication authentication;
                Object snapshotRepositoryDelegate;
                MavenRepository repository;
                MavenAuthentication authentication2;
                Object repositoryDelegate = deployer.getRepository();
                if (repositoryDelegate != null && (authentication2 = AuthenticationHandler.this.locateAuthenticationDetails(repository = new MavenRepository(repositoryDelegate, deployer.getClass().getClassLoader()))) != null) {
                    repository.addAuthentication(authentication2);
                }
                if ((snapshotRepositoryDelegate = deployer.getSnapshotRepository()) != null && (authentication = AuthenticationHandler.this.locateAuthenticationDetails(snapshotRepository = new MavenRepository(snapshotRepositoryDelegate, deployer.getClass().getClassLoader()))) != null) {
                    snapshotRepository.addAuthentication(authentication);
                }
            }
        });
    }

    private MavenAuthentication locateAuthenticationDetails(MavenRepository repository) {
        for (AuthenticationProvider provider : this.authenticationProviderRegistry.providers()) {
            MavenAuthentication authentication = provider.determineAuthentication(repository);
            if (authentication == null) continue;
            return authentication;
        }
        return null;
    }
}

