/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.build.gradle.upload.AuthenticationProvider;
import org.hibernate.build.gradle.upload.MavenAuthentication;
import org.hibernate.build.gradle.upload.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class StandardMavenAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(StandardMavenAuthenticationProvider.class);
    public static final String SETTINGS_LOCATION_OVERRIDE = "maven.settings";
    private ConcurrentHashMap<String, MavenAuthentication> repositoryAuthenticationMap;

    public MavenAuthentication determineAuthentication(MavenRepository remoteRepository) {
        if (this.repositoryAuthenticationMap == null) {
            this.loadRepositoryAuthenticationMap();
        }
        return this.repositoryAuthenticationMap.get(remoteRepository.getId());
    }

    private void loadRepositoryAuthenticationMap() {
        this.repositoryAuthenticationMap = new ConcurrentHashMap();
        File settingsFile = this.determineSettingsFileLocation();
        try {
            InputSource inputSource = new InputSource(new FileInputStream(settingsFile));
            try {
                Document document = this.buildSAXReader().read(inputSource);
                Element settingsElement = document.getRootElement();
                Element serversElement = settingsElement.element("servers");
                Iterator serversIterator = serversElement.elementIterator("server");
                while (serversIterator.hasNext()) {
                    Element serverElement = (Element)serversIterator.next();
                    String id = this.extractValue(serverElement.element("id"));
                    if (id == null) continue;
                    MavenAuthentication authentication = new MavenAuthentication();
                    authentication.setUserName(this.extractValue(serverElement.element("username")));
                    authentication.setPassword(this.extractValue(serverElement.element("password")));
                    authentication.setPrivateKey(this.extractValue(serverElement.element("privateKey")));
                    authentication.setPassphrase(this.extractValue(serverElement.element("passphrase")));
                    this.repositoryAuthenticationMap.put(id, authentication);
                }
            }
            catch (DocumentException e) {
                log.error("Error reading Maven settings.xml", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Unable to locate Maven settings.xml");
        }
    }

    private String extractValue(Element element) {
        if (element == null) {
            return null;
        }
        String value = element.getTextTrim();
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    private SAXReader buildSAXReader() {
        SAXReader saxReader = new SAXReader();
        saxReader.setMergeAdjacentText(true);
        return saxReader;
    }

    private File determineSettingsFileLocation() {
        String overrideLocation = System.getProperty(SETTINGS_LOCATION_OVERRIDE);
        return overrideLocation == null ? new File(new File(System.getProperty("user.home"), ".m2"), "settings.xml") : new File(overrideLocation);
    }
}

