/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.upload;

import java.lang.reflect.Method;
import org.hibernate.build.gradle.upload.MavenAuthentication;
import org.hibernate.build.gradle.upload.ReflectionException;

public class MavenRepository {
    private final Object delegate;
    private final ClassLoader classLoader;
    private Method idGetterMethod;
    private Method urlGetterMethod;
    private Method addAuthenticationMethod;
    private static final String REMOTE_REPO_CLASS_NAME = "org.apache.maven.artifact.ant.RemoteRepository";
    private Class remoteRepoClass;
    private Method userNameSetterMethod;
    private Method passwordSetterMethod;
    private Method privateKeySetterMethod;
    private Method passphraseSetterMethod;
    private static final String AUTH_CLASS_NAME = "org.apache.maven.artifact.ant.Authentication";
    private Class authClass;

    public MavenRepository(Object delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    public String getId() {
        try {
            return (String)this.idGetterMethod().invoke(this.delegate, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke getId method", e);
        }
    }

    public String getUrl() {
        try {
            return (String)this.urlGetterMethod().invoke(this.delegate, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke getUrl method", e);
        }
    }

    public void addAuthentication(MavenAuthentication authentication) {
        try {
            this.authenticationAdderMethod().invoke(this.delegate, this.getDelegate(authentication));
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke addAuthentication method", e);
        }
    }

    private Object getDelegate(MavenAuthentication authentication) {
        Object delegate;
        try {
            delegate = this.getAuthClass().newInstance();
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to instantiate org.apache.maven.artifact.ant.Authentication", e);
        }
        this.setUserName(authentication.getUserName(), delegate);
        this.setPassword(authentication.getPassword(), delegate);
        this.setPrivateKey(authentication.getPrivateKey(), delegate);
        this.setPassphrase(authentication.getPassphrase(), delegate);
        return delegate;
    }

    private void setUserName(String username, Object delegate) {
        try {
            this.getUserNameSetter().invoke(delegate, username);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke setUserName method", e);
        }
    }

    private void setPassword(String password, Object delegate) {
        try {
            this.getPasswordSetter().invoke(delegate, password);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke setPassword method", e);
        }
    }

    private void setPrivateKey(String privateKey, Object delegate) {
        try {
            this.getPrivateKeySetter().invoke(delegate, privateKey);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke setPrivateKey method", e);
        }
    }

    private void setPassphrase(String passphrase, Object delegate) {
        try {
            this.getPassphraseSetter().invoke(delegate, passphrase);
        }
        catch (Exception e) {
            throw new ReflectionException("Unable to invoke setPassphrase method", e);
        }
    }

    public Method idGetterMethod() {
        if (this.idGetterMethod == null) {
            this.idGetterMethod = this.locateIdGetterMethod();
        }
        return this.idGetterMethod;
    }

    private Method locateIdGetterMethod() {
        try {
            return this.getRemoteRepositoryClass().getMethod("getId", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate getId method", e);
        }
    }

    public Method urlGetterMethod() {
        if (this.urlGetterMethod == null) {
            this.urlGetterMethod = this.locateUrlGetterMethod();
        }
        return this.urlGetterMethod;
    }

    private Method locateUrlGetterMethod() {
        try {
            return this.getRemoteRepositoryClass().getMethod("getUrl", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate getUrl method", e);
        }
    }

    private Method authenticationAdderMethod() {
        if (this.addAuthenticationMethod == null) {
            this.addAuthenticationMethod = this.locateAuthenticationAdderMethod();
        }
        return this.addAuthenticationMethod;
    }

    private Method locateAuthenticationAdderMethod() {
        try {
            return this.getRemoteRepositoryClass().getMethod("addAuthentication", this.getAuthClass());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate addAuthentication method", e);
        }
    }

    public Class getRemoteRepositoryClass() {
        if (this.remoteRepoClass == null) {
            this.remoteRepoClass = this.locateRemoteRepositoryClass();
        }
        return this.remoteRepoClass;
    }

    private Class locateRemoteRepositoryClass() {
        try {
            return this.classLoader.loadClass(REMOTE_REPO_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Unable to locate class [org.apache.maven.artifact.ant.RemoteRepository]", e);
        }
    }

    private Method getUserNameSetter() {
        if (this.userNameSetterMethod == null) {
            this.userNameSetterMethod = this.locateUserNameSetter();
        }
        return this.userNameSetterMethod;
    }

    private Method locateUserNameSetter() {
        try {
            return this.getAuthClass().getMethod("setUserName", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate setUserName method", e);
        }
    }

    private Method getPasswordSetter() {
        if (this.passwordSetterMethod == null) {
            this.passwordSetterMethod = this.locatePasswordSetter();
        }
        return this.passwordSetterMethod;
    }

    private Method locatePasswordSetter() {
        try {
            return this.getAuthClass().getMethod("setPassword", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate setPassword method", e);
        }
    }

    private Method getPrivateKeySetter() {
        if (this.privateKeySetterMethod == null) {
            this.privateKeySetterMethod = this.locatePrivateKeySetter();
        }
        return this.privateKeySetterMethod;
    }

    private Method locatePrivateKeySetter() {
        try {
            return this.getAuthClass().getMethod("setPrivateKey", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate setPrivateKey method", e);
        }
    }

    private Method getPassphraseSetter() {
        if (this.passphraseSetterMethod == null) {
            this.passphraseSetterMethod = this.locatePassphraseSetter();
        }
        return this.passphraseSetterMethod;
    }

    private Method locatePassphraseSetter() {
        try {
            return this.getAuthClass().getMethod("setPassphrase", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not locate setPassphrase method", e);
        }
    }

    public Class getAuthClass() {
        if (this.authClass == null) {
            this.authClass = this.locateAuthClass();
        }
        return this.authClass;
    }

    private Class locateAuthClass() {
        try {
            return this.classLoader.loadClass(AUTH_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Unable to locate class [org.apache.maven.artifact.ant.Authentication]", e);
        }
    }
}

