/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.build.gradle.upload.AuthenticationProvider;
import org.hibernate.build.gradle.upload.MavenAuthentication;
import org.hibernate.build.gradle.upload.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;
import org.xml.sax.InputSource;

public class StandardMavenAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(StandardMavenAuthenticationProvider.class);
    public static final String SETTINGS_LOCATION_OVERRIDE = "maven.settings";
    private ConcurrentHashMap<String, MavenAuthentication> repositoryAuthenticationMap;

    public MavenAuthentication determineAuthentication(MavenRepository remoteRepository) {
        if (this.repositoryAuthenticationMap == null) {
            this.loadRepositoryAuthenticationMap();
        }
        return this.repositoryAuthenticationMap.get(remoteRepository.getId());
    }

    private PasswordReader determinePasswordReader() {
        File securitySettingsFile = this.determineSecuritySettingsFileLocation();
        String masterPasswordEntry = securitySettingsFile.exists() ? this.extractMasterPassword(securitySettingsFile) : null;
        System.out.println("master password entry : " + masterPasswordEntry);
        return masterPasswordEntry == null ? new BasicPasswordReader() : new PlexusCipherPasswordReader(masterPasswordEntry);
    }

    private String extractMasterPassword(File securitySettingsFile) {
        try {
            SettingsSecurity settingsSecurity = SecUtil.read((String)securitySettingsFile.getAbsolutePath(), (boolean)true);
            return settingsSecurity == null ? null : settingsSecurity.getMaster();
        }
        catch (SecDispatcherException e) {
            log.warn("Unable to read Maven security settings file", (Throwable)e);
            return null;
        }
    }

    private void loadRepositoryAuthenticationMap() {
        this.repositoryAuthenticationMap = new ConcurrentHashMap();
        PasswordReader passwordReader = this.determinePasswordReader();
        File settingsFile = this.determineSettingsFileLocation();
        try {
            InputSource inputSource = new InputSource(new FileInputStream(settingsFile));
            try {
                Document document = this.buildSAXReader().read(inputSource);
                Element settingsElement = document.getRootElement();
                Element serversElement = settingsElement.element("servers");
                Iterator serversIterator = serversElement.elementIterator("server");
                while (serversIterator.hasNext()) {
                    Element serverElement = (Element)serversIterator.next();
                    String id = StandardMavenAuthenticationProvider.extractValue(serverElement.element("id"));
                    if (id == null) continue;
                    MavenAuthentication authentication = this.extractServerValues(serverElement, passwordReader);
                    this.repositoryAuthenticationMap.put(id, authentication);
                }
            }
            catch (DocumentException e) {
                log.error("Error reading Maven settings.xml", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Unable to locate Maven settings.xml");
        }
    }

    private MavenAuthentication extractServerValues(Element serverElement, PasswordReader passwordReader) {
        MavenAuthentication authentication = new MavenAuthentication();
        authentication.setUserName(StandardMavenAuthenticationProvider.extractValue(serverElement.element("username")));
        authentication.setPassword(passwordReader.readPassword(serverElement.element("password")));
        authentication.setPrivateKey(StandardMavenAuthenticationProvider.extractValue(serverElement.element("privateKey")));
        authentication.setPassphrase(StandardMavenAuthenticationProvider.extractValue(serverElement.element("passphrase")));
        return authentication;
    }

    private static String extractValue(Element element) {
        if (element == null) {
            return null;
        }
        String value = element.getTextTrim();
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    private SAXReader buildSAXReader() {
        SAXReader saxReader = new SAXReader(new DocumentFactory());
        saxReader.setMergeAdjacentText(true);
        return saxReader;
    }

    private File determineSecuritySettingsFileLocation() {
        String defaultLocation = "~/.m2/settings-security.xml";
        String location = System.getProperty("settings.security", "~/.m2/settings-security.xml");
        return new File(StandardMavenAuthenticationProvider.normalizePath(location));
    }

    private static String normalizePath(String path) {
        if (path.startsWith("~")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        return path;
    }

    private File determineSettingsFileLocation() {
        String defaultLocation = "~/.m2/settings.xml";
        String location = System.getProperty(SETTINGS_LOCATION_OVERRIDE, "~/.m2/settings.xml");
        return new File(StandardMavenAuthenticationProvider.normalizePath(location));
    }

    private static class PlexusCipherPasswordReader
    implements PasswordReader {
        private final DefaultPlexusCipher cipher = PlexusCipherPasswordReader.buildCipher();
        private final String master;

        private PlexusCipherPasswordReader(String master) {
            this.master = PlexusCipherPasswordReader.decryptMaster(master, this.cipher);
        }

        private static DefaultPlexusCipher buildCipher() {
            try {
                return new DefaultPlexusCipher();
            }
            catch (PlexusCipherException e) {
                log.error("Unable to create PlexusCipher in order to decrypt Maven passwords");
                return null;
            }
        }

        private static String decryptMaster(String master, DefaultPlexusCipher cipher) {
            try {
                return cipher.decryptDecorated(master, "settings.security");
            }
            catch (PlexusCipherException e) {
                log.error("Unable to create PlexusCipher in order to decrypt Maven passwords");
                return null;
            }
        }

        public String readPassword(Element passwordElement) {
            String value = StandardMavenAuthenticationProvider.extractValue(passwordElement);
            try {
                return this.cipher.decryptDecorated(value, this.master);
            }
            catch (PlexusCipherException e) {
                log.warn("Unable to decrypt Maven password using PlexusCipher", (Throwable)e);
                return value;
            }
        }
    }

    private static class BasicPasswordReader
    implements PasswordReader {
        private BasicPasswordReader() {
        }

        public String readPassword(Element passwordElement) {
            return StandardMavenAuthenticationProvider.extractValue(passwordElement);
        }
    }

    private static interface PasswordReader {
        public String readPassword(Element var1);
    }
}

