/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java;

import junit.framework.TestCase;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;

public class JavaReflectionManagerTest
extends TestCase {
    private ReflectionManager rm = new JavaReflectionManager();

    public void testReturnsAnXClassThatWrapsTheGivenClass() {
        XClass xc = this.rm.toXClass(Integer.class);
        JavaReflectionManagerTest.assertEquals((String)"java.lang.Integer", (String)xc.getName());
    }

    public void testReturnsSameXClassForSameClass() {
        XClass xc1 = this.rm.toXClass(Void.TYPE);
        XClass xc2 = this.rm.toXClass(Void.TYPE);
        JavaReflectionManagerTest.assertSame((Object)xc2, (Object)xc1);
    }

    public void testReturnsNullForANullClass() {
        JavaReflectionManagerTest.assertNull((Object)this.rm.toXClass(null));
    }

    public void testComparesXClassesWithClasses() {
        XClass xc = this.rm.toXClass(Integer.class);
        JavaReflectionManagerTest.assertTrue((boolean)this.rm.equals(xc, Integer.class));
    }

    public void testSupportsNullsInComparisons() {
        XClass xc = this.rm.toXClass(Integer.class);
        JavaReflectionManagerTest.assertFalse((boolean)this.rm.equals(null, Number.class));
        JavaReflectionManagerTest.assertFalse((boolean)this.rm.equals(xc, null));
        JavaReflectionManagerTest.assertTrue((boolean)this.rm.equals(null, null));
    }
}

