/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal.advisor;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import org.hibernate.jpa.graph.internal.advisor.AdviceHelper;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphCollectionReference;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphReference;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphSingularAttributeReference;
import org.hibernate.jpa.graph.internal.advisor.NoOpJpaGraphReference;
import org.hibernate.jpa.graph.spi.AttributeNodeImplementor;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.jboss.logging.Logger;

abstract class JpaGraphReferenceSubGraphSupport
implements JpaGraphReference {
    private static final Logger log = Logger.getLogger(JpaGraphReferenceSubGraphSupport.class);
    private final Map<String, AttributeNodeImplementor> elementGraphAttributeMap = new HashMap<String, AttributeNodeImplementor>();

    protected JpaGraphReferenceSubGraphSupport(AttributeNodeImplementor<?> attributeNode) {
        for (Subgraph subgraph : attributeNode.getSubgraphs().values()) {
            for (AttributeNode subGraphAttributeNode : subgraph.getAttributeNodes()) {
                AttributeNodeImplementor nodeImplementor = (AttributeNodeImplementor)subGraphAttributeNode;
                AttributeNodeImplementor old = this.elementGraphAttributeMap.put(nodeImplementor.getAttributeName(), nodeImplementor);
                if (old == null || old == nodeImplementor) continue;
                throw new IllegalStateException("Found multiple representations of the same attribute : " + nodeImplementor.getAttributeName());
            }
        }
    }

    @Override
    public JpaGraphReference attributeProcessed(String attributeName) {
        AttributeNodeImplementor attributeNode = this.elementGraphAttributeMap.remove(attributeName);
        if (attributeNode == null) {
            return NoOpJpaGraphReference.INSTANCE;
        }
        return attributeNode.getAttribute().isCollection() ? new JpaGraphCollectionReference(attributeNode) : new JpaGraphSingularAttributeReference(attributeNode);
    }

    @Override
    public void applyMissingFetches(FetchOwner fetchOwner) {
        for (AttributeNodeImplementor attributeNode : this.elementGraphAttributeMap.values()) {
            System.out.println(String.format("Found unprocessed attribute node [%s], applying to fetch-owner [%s]", attributeNode.getAttributeName(), fetchOwner.getPropertyPath().getFullPath()));
            log.tracef("Found unprocessed attribute node [%s], applying to fetch-owner [%s]", (Object)attributeNode.getAttributeName(), (Object)fetchOwner.getPropertyPath());
            AdviceHelper.buildFetch(fetchOwner, attributeNode);
        }
    }
}

