/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import org.hibernate.engine.jdbc.internal.DDLFormatterImpl;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;

class JdbcConnectionContext {
    private final JdbcConnectionAccess jdbcConnectionAccess;
    private final SqlStatementLogger sqlStatementLogger;
    private Connection jdbcConnection;

    JdbcConnectionContext(JdbcConnectionAccess jdbcConnectionAccess, SqlStatementLogger sqlStatementLogger) {
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.sqlStatementLogger = sqlStatementLogger;
    }

    public Connection getJdbcConnection() {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = this.jdbcConnectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to obtain JDBC Connection", (Throwable)e);
            }
        }
        return this.jdbcConnection;
    }

    public void release() {
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnectionAccess.releaseConnection(this.jdbcConnection);
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to release JDBC Connection", (Throwable)e);
            }
        }
    }

    public void logSqlStatement(String sqlStatement) {
        this.sqlStatementLogger.logStatement(sqlStatement, (Formatter)DDLFormatterImpl.INSTANCE);
    }
}

