/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.query;

import java.util.Collections;
import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public final class OneAuditEntityQueryGenerator
implements RelationQueryGenerator {
    private final String queryString;
    private final MiddleIdData referencingIdData;

    public OneAuditEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, MiddleIdData referencingIdData, String referencedEntityName, IdMapper referencedIdMapper) {
        this.referencingIdData = referencingIdData;
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        String versionsReferencedEntityName = verEntCfg.getAuditEntityName(referencedEntityName);
        QueryBuilder qb = new QueryBuilder(versionsReferencedEntityName, "e");
        qb.addProjection("new list", "e", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, null, true);
        QueryBuilder maxERevQb = qb.newSubQueryBuilder(versionsReferencedEntityName, "e2");
        maxERevQb.addProjection("max", revisionPropertyPath, false);
        Parameters maxERevQbParameters = maxERevQb.getRootParameters();
        maxERevQbParameters.addWhereWithNamedParam(revisionPropertyPath, "<=", "revision");
        referencedIdMapper.addIdsEqualToQuery(maxERevQbParameters, "e." + originalIdPropertyName, "e2." + originalIdPropertyName);
        rootParameters.addWhere(revisionPropertyPath, false, globalCfg.getCorrelatedSubqueryOperator(), maxERevQb);
        rootParameters.addWhereWithNamedParam(verEntCfg.getRevisionTypePropName(), false, "!=", "delrevisiontype");
        StringBuilder sb = new StringBuilder();
        qb.build(sb, Collections.<String, Object>emptyMap());
        this.queryString = sb.toString();
    }

    public Query getQuery(AuditReaderImplementor versionsReader, Object primaryKey, Number revision) {
        Query query = versionsReader.getSession().createQuery(this.queryString);
        query.setParameter("revision", (Object)revision);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        for (QueryParameterData paramData : this.referencingIdData.getPrefixedMapper().mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }
}

