/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.Setter;

public class ComponentPropertyMapper
implements PropertyMapper,
CompositeMapperBuilder {
    private final PropertyData propertyData;
    private final MultiPropertyMapper delegate;
    private final String componentClassName;

    public ComponentPropertyMapper(PropertyData propertyData, String componentClassName) {
        this.propertyData = propertyData;
        this.delegate = new MultiPropertyMapper();
        this.componentClassName = componentClassName;
    }

    @Override
    public void add(PropertyData propertyData) {
        this.delegate.add(propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, String componentClassName) {
        return this.delegate.addComponent(propertyData, componentClassName);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.delegate.addComposite(propertyData, propertyMapper);
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return this.delegate.mapToMapFromEntity(session, data, newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        boolean allNullAndSingle = true;
        for (Map.Entry<PropertyData, PropertyMapper> property : this.delegate.getProperties().entrySet()) {
            if (data.get(property.getKey().getName()) == null && property.getValue() instanceof SinglePropertyMapper) continue;
            allNullAndSingle = false;
            break;
        }
        if (allNullAndSingle) {
            setter.set(obj, null, null);
        } else {
            try {
                Object subObj = ReflectHelper.getDefaultConstructor(Thread.currentThread().getContextClassLoader().loadClass(this.componentClassName)).newInstance(new Object[0]);
                setter.set(obj, subObj, null);
                this.delegate.mapToEntityFromMap(verCfg, subObj, data, primaryKey, versionsReader, revision);
            }
            catch (Exception e) {
                throw new AuditException(e);
            }
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return this.delegate.mapCollectionChanges(referencingPropertyName, newColl, oldColl, id);
    }
}

