/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;

public abstract class AbstractAuditWorkUnit
implements AuditWorkUnit {
    protected final SessionImplementor sessionImplementor;
    protected final AuditConfiguration verCfg;
    protected final Serializable id;
    protected final String entityName;
    protected final AuditStrategy auditStrategy;
    private Object performedData;

    protected AbstractAuditWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration verCfg, Serializable id) {
        this.sessionImplementor = sessionImplementor;
        this.verCfg = verCfg;
        this.id = id;
        this.entityName = entityName;
        this.auditStrategy = verCfg.getAuditStrategy();
    }

    protected void fillDataWithId(Map<String, Object> data, Object revision, RevisionType revisionType) {
        AuditEntitiesConfiguration entitiesCfg = this.verCfg.getAuditEntCfg();
        HashMap<String, Object> originalId = new HashMap<String, Object>();
        originalId.put(entitiesCfg.getRevisionFieldName(), revision);
        this.verCfg.getEntCfg().get(this.getEntityName()).getIdMapper().mapToMapFromId(originalId, this.id);
        data.put(entitiesCfg.getRevisionTypePropName(), (Object)revisionType);
        data.put(entitiesCfg.getOriginalIdPropName(), originalId);
    }

    @Override
    public void perform(Session session, Object revisionData) {
        Map<String, Object> data = this.generateData(revisionData);
        this.auditStrategy.perform(session, this.getEntityName(), this.verCfg, this.id, data, revisionData);
        this.setPerformed(data);
    }

    @Override
    public Object getEntityId() {
        return this.id;
    }

    @Override
    public boolean isPerformed() {
        return this.performedData != null;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    protected void setPerformed(Object performedData) {
        this.performedData = performedData;
    }

    @Override
    public void undo(Session session) {
        if (this.isPerformed()) {
            session.delete(this.verCfg.getAuditEntCfg().getAuditEntityName(this.getEntityName()), this.performedData);
            session.flush();
        }
    }
}

