/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class DefaultAuditStrategy
implements AuditStrategy {
    @Override
    public void perform(Session session, String entityName, AuditConfiguration auditCfg, Serializable id, Object data, Object revision) {
        session.save(auditCfg.getAuditEntCfg().getAuditEntityName(entityName), data);
    }

    @Override
    public void performCollectionChange(Session session, AuditConfiguration auditCfg, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
    }

    @Override
    public void addEntityAtRevisionRestriction(GlobalConfiguration globalCfg, QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        QueryBuilder maxERevQb = rootQueryBuilder.newSubQueryBuilder(idData.getAuditEntityName(), alias2);
        maxERevQb.addProjection("max", revisionPropertyPath, false);
        Parameters maxERevQbParameters = maxERevQb.getRootParameters();
        maxERevQbParameters.addWhereWithNamedParam(revisionPropertyPath, "<=", "revision");
        idData.getOriginalMapper().addIdsEqualToQuery(maxERevQbParameters, alias1 + "." + originalIdPropertyName, alias2 + "." + originalIdPropertyName);
        String subqueryOperator = globalCfg.getCorrelatedSubqueryOperator();
        rootParameters.addWhere(revisionProperty, addAlias, subqueryOperator, maxERevQb);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, MiddleComponentData ... componentDatas) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        QueryBuilder maxEeRevQb = rootQueryBuilder.newSubQueryBuilder(versionsMiddleEntityName, "ee2");
        maxEeRevQb.addProjection("max", revisionPropertyPath, false);
        Parameters maxEeRevQbParameters = maxEeRevQb.getRootParameters();
        maxEeRevQbParameters.addWhereWithNamedParam(revisionPropertyPath, "<=", "revision");
        String ee2OriginalIdPropertyPath = "ee2." + originalIdPropertyName;
        referencingIdData.getPrefixedMapper().addIdsEqualToQuery(maxEeRevQbParameters, eeOriginalIdPropertyPath, ee2OriginalIdPropertyPath);
        for (MiddleComponentData componentData : componentDatas) {
            componentData.getComponentMapper().addMiddleEqualToQuery(maxEeRevQbParameters, eeOriginalIdPropertyPath, ee2OriginalIdPropertyPath);
        }
        rootParameters.addWhere(revisionProperty, addAlias, "=", maxEeRevQb);
    }
}

