/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.envers.synchronization.work.WorkUnitMergeVisitor;

public class CollectionChangeWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private Object entity;
    private final String collectionPropertyName;
    private final Map<String, Object> data = new HashMap<String, Object>();

    public CollectionChangeWorkUnit(SessionImplementor session, String entityName, String collectionPropertyName, AuditConfiguration verCfg, Serializable id, Object entity) {
        super(session, entityName, verCfg, id, RevisionType.MOD);
        this.entity = entity;
        this.collectionPropertyName = collectionPropertyName;
    }

    @Override
    public boolean containsWork() {
        return true;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        this.fillDataWithId(this.data, revisionData);
        HashMap<String, Object> preGenerateData = new HashMap<String, Object>(this.data);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapToMapFromEntity(this.sessionImplementor, this.data, this.entity, null);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapModifiedFlagsToMapFromEntity(this.sessionImplementor, this.data, this.entity, this.entity);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapModifiedFlagsToMapForCollectionChange(this.collectionPropertyName, this.data);
        this.data.putAll(preGenerateData);
        return this.data;
    }

    public void mergeCollectionModifiedData(Map<String, Object> data) {
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapModifiedFlagsToMapForCollectionChange(this.collectionPropertyName, data);
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        this.mergeCollectionModifiedData(second.getData());
        return second;
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        second.mergeCollectionModifiedData(this.data);
        return this;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        return first.merge(this);
    }
}

