/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.OneEntityQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.ThreeEntityQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.TwoEntityOneAuditedQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.TwoEntityQueryGenerator;
import org.hibernate.envers.strategy.AuditStrategy;

public final class QueryGeneratorBuilder {
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration verEntCfg;
    private final AuditStrategy auditStrategy;
    private final MiddleIdData referencingIdData;
    private final String auditMiddleEntityName;
    private final List<MiddleIdData> idDatas;
    private final boolean revisionTypeInId;

    QueryGeneratorBuilder(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, MiddleIdData referencingIdData, String auditMiddleEntityName, boolean revisionTypeInId) {
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.auditStrategy = auditStrategy;
        this.referencingIdData = referencingIdData;
        this.auditMiddleEntityName = auditMiddleEntityName;
        this.revisionTypeInId = revisionTypeInId;
        this.idDatas = new ArrayList<MiddleIdData>();
    }

    void addRelation(MiddleIdData idData) {
        this.idDatas.add(idData);
    }

    RelationQueryGenerator build(MiddleComponentData ... componentDatas) {
        if (this.idDatas.size() == 0) {
            return new OneEntityQueryGenerator(this.verEntCfg, this.auditStrategy, this.auditMiddleEntityName, this.referencingIdData, this.revisionTypeInId, componentDatas);
        }
        if (this.idDatas.size() == 1) {
            if (this.idDatas.get(0).isAudited()) {
                return new TwoEntityQueryGenerator(this.globalCfg, this.verEntCfg, this.auditStrategy, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.revisionTypeInId, componentDatas);
            }
            return new TwoEntityOneAuditedQueryGenerator(this.verEntCfg, this.auditStrategy, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.revisionTypeInId, componentDatas);
        }
        if (this.idDatas.size() == 2) {
            if (!this.idDatas.get(0).isAudited() || !this.idDatas.get(1).isAudited()) {
                throw new MappingException("Ternary relations using @Audited(targetAuditMode = NOT_AUDITED) are not supported.");
            }
            return new ThreeEntityQueryGenerator(this.globalCfg, this.verEntCfg, this.auditStrategy, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.idDatas.get(1), this.revisionTypeInId, componentDatas);
        }
        throw new IllegalStateException("Illegal number of related entities.");
    }

    int getCurrentIndex() {
        return this.idDatas.size();
    }
}

