/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.spi;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.EntitiesConfigurator;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.configuration.internal.RevisionInfoConfiguration;
import org.hibernate.envers.configuration.internal.RevisionInfoConfigurationResult;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.synchronization.AuditProcessManager;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.ValidityAuditStrategy;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.Getter;
import org.hibernate.service.ServiceRegistry;

public class AuditConfiguration {
    private final ServiceRegistry serviceRegistry;
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration auditEntCfg;
    private final AuditProcessManager auditProcessManager;
    private final AuditStrategy auditStrategy;
    private final EntitiesConfigurations entCfg;
    private final RevisionInfoQueryCreator revisionInfoQueryCreator;
    private final RevisionInfoNumberReader revisionInfoNumberReader;
    private final ModifiedEntityNamesReader modifiedEntityNamesReader;

    public AuditConfiguration(MetadataImplementor metadata, MappingCollector mappingCollector) {
        this.serviceRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry();
        ConfigurationService cfgService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)cfgService.getSettings());
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        this.globalCfg = new GlobalConfiguration(properties, classLoaderService);
        ReflectionManager reflectionManager = metadata.getMetadataBuildingOptions().getReflectionManager();
        RevisionInfoConfiguration revInfoCfg = new RevisionInfoConfiguration(this.globalCfg);
        RevisionInfoConfigurationResult revInfoCfgResult = revInfoCfg.configure(metadata, reflectionManager);
        this.auditEntCfg = new AuditEntitiesConfiguration(properties, revInfoCfgResult.getRevisionInfoEntityName());
        this.auditProcessManager = new AuditProcessManager(revInfoCfgResult.getRevisionInfoGenerator());
        this.revisionInfoQueryCreator = revInfoCfgResult.getRevisionInfoQueryCreator();
        this.revisionInfoNumberReader = revInfoCfgResult.getRevisionInfoNumberReader();
        this.modifiedEntityNamesReader = revInfoCfgResult.getModifiedEntityNamesReader();
        this.auditStrategy = AuditConfiguration.initializeAuditStrategy(this.auditEntCfg.getAuditStrategyName(), revInfoCfgResult.getRevisionInfoClass(), revInfoCfgResult.getRevisionInfoTimestampData(), classLoaderService);
        this.entCfg = new EntitiesConfigurator().configure(metadata, this.serviceRegistry, reflectionManager, mappingCollector, this.globalCfg, this.auditEntCfg, this.auditStrategy, revInfoCfgResult.getRevisionInfoXmlMapping(), revInfoCfgResult.getRevisionInfoRelationMapping());
    }

    public AuditEntitiesConfiguration getAuditEntCfg() {
        return this.auditEntCfg;
    }

    public AuditProcessManager getSyncManager() {
        return this.auditProcessManager;
    }

    public GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    public EntitiesConfigurations getEntCfg() {
        return this.entCfg;
    }

    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        return this.revisionInfoQueryCreator;
    }

    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        return this.revisionInfoNumberReader;
    }

    public ModifiedEntityNamesReader getModifiedEntityNamesReader() {
        return this.modifiedEntityNamesReader;
    }

    public AuditStrategy getAuditStrategy() {
        return this.auditStrategy;
    }

    private static AuditStrategy initializeAuditStrategy(String auditStrategyName, Class<?> revisionInfoClass, PropertyData revisionInfoTimestampData, ClassLoaderService classLoaderService) {
        AuditStrategy strategy;
        try {
            Class<?> auditStrategyClass = AuditConfiguration.loadClass(auditStrategyName, classLoaderService);
            strategy = (AuditStrategy)ReflectHelper.getDefaultConstructor(auditStrategyClass).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException(String.format("Unable to create AuditStrategy [%s] instance.", auditStrategyName), (Throwable)e);
        }
        if (strategy instanceof ValidityAuditStrategy) {
            Getter revisionTimestampGetter = ReflectionTools.getGetter(revisionInfoClass, revisionInfoTimestampData);
            ((ValidityAuditStrategy)strategy).setRevisionTimestampGetter(revisionTimestampGetter);
        }
        return strategy;
    }

    private static Class<?> loadClass(String auditStrategyName, ClassLoaderService classLoaderService) {
        try {
            return AuditConfiguration.class.getClassLoader().loadClass(auditStrategyName);
        }
        catch (Exception e) {
            return ReflectionTools.loadClass(auditStrategyName, classLoaderService);
        }
    }

    public void destroy() {
    }
}

