/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.util.List;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.EntityInstantiator;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public abstract class AbstractCollectionInitializor<T>
implements Initializor<T> {
    private final AuditReaderImplementor versionsReader;
    private final RelationQueryGenerator queryGenerator;
    private final Object primaryKey;
    protected final Number revision;
    protected final boolean removed;
    protected final EntityInstantiator entityInstantiator;

    public AbstractCollectionInitializor(EnversService enversService, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed) {
        this.versionsReader = versionsReader;
        this.queryGenerator = queryGenerator;
        this.primaryKey = primaryKey;
        this.revision = revision;
        this.removed = removed;
        this.entityInstantiator = new EntityInstantiator(enversService, versionsReader);
    }

    protected abstract T initializeCollection(int var1);

    protected abstract void addToCollection(T var1, Object var2);

    @Override
    public T initialize() {
        SessionImplementor session = this.versionsReader.getSessionImplementor();
        List collectionContent = this.queryGenerator.getQuery((SharedSessionContractImplementor)session, this.primaryKey, this.revision, this.removed).list();
        T collection = this.initializeCollection(collectionContent.size());
        for (Object collectionRow : collectionContent) {
            this.addToCollection(collection, collectionRow);
        }
        return collection;
    }
}

