/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.hibernate.bytecode.enhance.plugins.EnhanceTask;

public class EnhancePlugin
implements Plugin<Project> {
    public static final String ENHANCE_TASK_NAME = "enhance";
    public static final String HAPPENS_AFTER_ENHANCE_TASK_NAME = "jar";

    public void apply(Project project) {
        project.getLogger().debug("Applying enhance plugin to project.");
        this.configureTask(project);
        project.getLogger().debug(String.format("DAG has been configured with enhance task dependent on [%s].", "classes"));
    }

    private void configureTask(Project project) {
        EnhanceTask enhanceTask = (EnhanceTask)project.getTasks().create(ENHANCE_TASK_NAME, EnhanceTask.class);
        enhanceTask.setGroup("build");
        Task classesTask = project.getTasks().getByName("classes");
        enhanceTask.dependsOn(new Object[]{classesTask});
        Task jarTask = project.getTasks().getByName(HAPPENS_AFTER_ENHANCE_TASK_NAME);
        jarTask.dependsOn(new Object[]{enhanceTask});
    }
}

