/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.infinispan.TypeOverrides;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.query.QueryResultsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.TimestampTypeOverrides;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.infinispan.tm.HibernateTransactionManagerLookup;
import org.hibernate.cfg.Settings;
import org.hibernate.util.PropertiesHelper;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanRegionFactory
implements RegionFactory {
    private static final Logger log = LoggerFactory.getLogger(InfinispanRegionFactory.class);
    private static final String PREFIX = "hibernate.cache.infinispan.";
    private static final String CONFIG_SUFFIX = ".cfg";
    private static final String STRATEGY_SUFFIX = ".eviction.strategy";
    private static final String WAKE_UP_INTERVAL_SUFFIX = ".eviction.wake_up_interval";
    private static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    private static final String LIFESPAN_SUFFIX = ".expiration.lifespan";
    private static final String MAX_IDLE_SUFFIX = ".expiration.max_idle";
    public static final String INFINISPAN_CONFIG_RESOURCE_PROP = "hibernate.cache.infinispan.cfg";
    private static final String ENTITY_KEY = "entity";
    public static final String ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.entity.cfg";
    private static final String COLLECTION_KEY = "collection";
    public static final String COLLECTION_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.collection.cfg";
    private static final String TIMESTAMPS_KEY = "timestamps";
    public static final String TIMESTAMPS_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.timestamps.cfg";
    private static final String QUERY_KEY = "query";
    public static final String QUERY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.query.cfg";
    public static final String DEF_INFINISPAN_CONFIG_RESOURCE = "org/hibernate/cache/infinispan/builder/infinispan-configs.xml";
    public static final String DEF_ENTITY_RESOURCE = "entity";
    public static final String DEF_TIMESTAMPS_RESOURCE = "timestamps";
    public static final String DEF_QUERY_RESOURCE = "local-query";
    private CacheManager manager;
    private final Map<String, TypeOverrides> typeOverrides = new HashMap<String, TypeOverrides>();
    private final Set<String> definedConfigurations = new HashSet<String>();
    private TransactionManagerLookup transactionManagerlookup;
    private TransactionManager transactionManager;

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        log.debug("Building collection cache region [" + regionName + "]");
        Cache cache = this.getCache(regionName, COLLECTION_KEY, properties);
        return new CollectionRegionImpl(cache, regionName, metadata, this.transactionManager);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Building entity cache region [" + regionName + "]");
        }
        Cache cache = this.getCache(regionName, "entity", properties);
        return new EntityRegionImpl(cache, regionName, metadata, this.transactionManager);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        log.debug("Building query results cache region [" + regionName + "]");
        String cacheName = this.typeOverrides.get(QUERY_KEY).getCacheName();
        return new QueryResultsRegionImpl(this.manager.getCache(cacheName), regionName, properties, this.transactionManager);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        log.debug("Building timestamps cache region [" + regionName + "]");
        String cacheName = this.typeOverrides.get("timestamps").getCacheName();
        return new TimestampsRegionImpl(this.manager.getCache(cacheName), regionName, this.transactionManager);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void setCacheManager(CacheManager manager) {
        this.manager = manager;
    }

    public CacheManager getCacheManager() {
        return this.manager;
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        log.debug("Starting Infinispan region factory");
        try {
            this.transactionManagerlookup = new HibernateTransactionManagerLookup(settings, properties);
            this.transactionManager = this.transactionManagerlookup.getTransactionManager();
            this.manager = this.createCacheManager(properties);
            this.initGenericDataTypeOverrides();
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int prefixLoc = -1;
                prefixLoc = key.indexOf(PREFIX);
                if (prefixLoc == -1) continue;
                this.dissectProperty(prefixLoc, key, properties);
            }
            this.defineGenericDataTypeCacheConfigurations(settings, properties);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CacheException("Unable to start region factory", t);
        }
    }

    public void stop() {
        log.debug("Stopping Infinispan CacheManager");
        this.manager.stop();
    }

    public Map<String, TypeOverrides> getTypeOverrides() {
        return Collections.unmodifiableMap(this.typeOverrides);
    }

    public Set<String> getDefinedConfigurations() {
        return Collections.unmodifiableSet(this.definedConfigurations);
    }

    protected CacheManager createCacheManager(Properties properties) throws CacheException {
        try {
            String configLoc = PropertiesHelper.getString((String)INFINISPAN_CONFIG_RESOURCE_PROP, (Properties)properties, (String)DEF_INFINISPAN_CONFIG_RESOURCE);
            return new DefaultCacheManager(configLoc);
        }
        catch (IOException e) {
            throw new CacheException("Unable to create default cache manager", (Throwable)e);
        }
    }

    private Map<String, TypeOverrides> initGenericDataTypeOverrides() {
        TypeOverrides entityOverrides = new TypeOverrides();
        entityOverrides.setCacheName("entity");
        this.typeOverrides.put("entity", entityOverrides);
        TypeOverrides collectionOverrides = new TypeOverrides();
        collectionOverrides.setCacheName("entity");
        this.typeOverrides.put(COLLECTION_KEY, collectionOverrides);
        TimestampTypeOverrides timestampOverrides = new TimestampTypeOverrides();
        timestampOverrides.setCacheName("timestamps");
        this.typeOverrides.put("timestamps", timestampOverrides);
        TypeOverrides queryOverrides = new TypeOverrides();
        queryOverrides.setCacheName(DEF_QUERY_RESOURCE);
        this.typeOverrides.put(QUERY_KEY, queryOverrides);
        return this.typeOverrides;
    }

    private void dissectProperty(int prefixLoc, String key, Properties properties) {
        TypeOverrides cfgOverride = null;
        int suffixLoc = -1;
        if (!key.equals(INFINISPAN_CONFIG_RESOURCE_PROP) && (suffixLoc = key.indexOf(CONFIG_SUFFIX)) != -1) {
            cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
            cfgOverride.setCacheName(PropertiesHelper.extractPropertyValue((String)key, (Properties)properties));
        } else {
            suffixLoc = key.indexOf(STRATEGY_SUFFIX);
            if (suffixLoc != -1) {
                cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                cfgOverride.setEvictionStrategy(PropertiesHelper.extractPropertyValue((String)key, (Properties)properties));
            } else {
                suffixLoc = key.indexOf(WAKE_UP_INTERVAL_SUFFIX);
                if (suffixLoc != -1) {
                    cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                    cfgOverride.setEvictionWakeUpInterval(Long.parseLong(PropertiesHelper.extractPropertyValue((String)key, (Properties)properties)));
                } else {
                    suffixLoc = key.indexOf(MAX_ENTRIES_SUFFIX);
                    if (suffixLoc != -1) {
                        cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                        cfgOverride.setEvictionMaxEntries(PropertiesHelper.getInt((String)key, (Properties)properties, (int)-1));
                    } else {
                        suffixLoc = key.indexOf(LIFESPAN_SUFFIX);
                        if (suffixLoc != -1) {
                            cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                            cfgOverride.setExpirationLifespan(Long.parseLong(PropertiesHelper.extractPropertyValue((String)key, (Properties)properties)));
                        } else {
                            suffixLoc = key.indexOf(MAX_IDLE_SUFFIX);
                            if (suffixLoc != -1) {
                                cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                                cfgOverride.setExpirationMaxIdle(Long.parseLong(PropertiesHelper.extractPropertyValue((String)key, (Properties)properties)));
                            }
                        }
                    }
                }
            }
        }
    }

    private TypeOverrides getOrCreateConfig(int prefixLoc, String key, int suffixLoc) {
        String name = key.substring(prefixLoc + PREFIX.length(), suffixLoc);
        TypeOverrides cfgOverride = this.typeOverrides.get(name);
        if (cfgOverride == null) {
            cfgOverride = new TypeOverrides();
            this.typeOverrides.put(name, cfgOverride);
        }
        return cfgOverride;
    }

    private void defineGenericDataTypeCacheConfigurations(Settings settings, Properties properties) throws CacheException {
        String[] defaultGenericDataTypes;
        for (String type : defaultGenericDataTypes = new String[]{"entity", COLLECTION_KEY, "timestamps", QUERY_KEY}) {
            TypeOverrides override = this.typeOverrides.get(type);
            String cacheName = override.getCacheName();
            Configuration newCacheCfg = override.createInfinispanConfiguration();
            Configuration cacheConfig = this.manager.defineConfiguration(cacheName, cacheName, newCacheCfg);
            cacheConfig = this.configureTransactionManager(cacheConfig, cacheName, properties);
            this.manager.defineConfiguration(cacheName, cacheName, cacheConfig);
            this.definedConfigurations.add(cacheName);
            override.validateInfinispanConfiguration(cacheConfig);
        }
    }

    private Cache getCache(String regionName, String typeKey, Properties properties) {
        TypeOverrides regionOverride = this.typeOverrides.get(regionName);
        if (!this.definedConfigurations.contains(regionName)) {
            String templateCacheName = null;
            Configuration regionCacheCfg = null;
            if (regionOverride != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Entity cache region specific configuration exists: " + regionOverride);
                }
                regionCacheCfg = regionOverride.createInfinispanConfiguration();
                String cacheName = regionOverride.getCacheName();
                templateCacheName = cacheName != null ? cacheName : this.typeOverrides.get(typeKey).getCacheName();
            } else {
                templateCacheName = this.typeOverrides.get(typeKey).getCacheName();
                regionCacheCfg = this.typeOverrides.get(typeKey).createInfinispanConfiguration();
            }
            regionCacheCfg = this.configureTransactionManager(regionCacheCfg, templateCacheName, properties);
            this.manager.defineConfiguration(regionName, templateCacheName, regionCacheCfg);
            this.definedConfigurations.add(regionName);
        }
        return this.manager.getCache(regionName);
    }

    private Configuration configureTransactionManager(Configuration regionOverrides, String templateCacheName, Properties properties) {
        Configuration templateConfig = this.manager.defineConfiguration(templateCacheName, new Configuration());
        String ispnTmLookupClassName = templateConfig.getTransactionManagerLookupClass();
        String hbTmLookupClassName = HibernateTransactionManagerLookup.class.getName();
        if (ispnTmLookupClassName != null && !ispnTmLookupClassName.equals(hbTmLookupClassName)) {
            log.debug("Infinispan is configured [" + ispnTmLookupClassName + "] with a different transaction manager lookup " + "class than Hibernate [" + hbTmLookupClassName + "]");
        } else {
            regionOverrides.setTransactionManagerLookup(this.transactionManagerlookup);
        }
        return regionOverrides;
    }
}

