/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.PropertiesHelper;
import org.infinispan.manager.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiInfinispanRegionFactory
extends InfinispanRegionFactory {
    private static final Logger log = LoggerFactory.getLogger(JndiInfinispanRegionFactory.class);
    public static final String CACHE_MANAGER_RESOURCE_PROP = "hibernate.cache.infinispan.cachemanager";

    @Override
    protected CacheManager createCacheManager(Properties properties) throws CacheException {
        String name = PropertiesHelper.getString((String)CACHE_MANAGER_RESOURCE_PROP, (Properties)properties, null);
        if (name == null) {
            throw new CacheException("Configuration property hibernate.cache.infinispan.cachemanager not set");
        }
        return this.locateCacheManager(name, NamingHelper.getJndiProperties((Properties)properties));
    }

    private CacheManager locateCacheManager(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            CacheManager cacheManager = (CacheManager)ctx.lookup(jndiNamespace);
            return cacheManager;
        }
        catch (NamingException ne) {
            String msg = "Unable to retrieve CacheManager from JNDI [" + jndiNamespace + "]";
            log.info(msg, (Throwable)ne);
            throw new CacheException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.info("Unable to release initial context", (Throwable)ne);
                }
            }
        }
    }
}

