/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.util.Locale;
import org.hibernate.cache.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;

public class TypeOverrides {
    private String cacheName;
    private EvictionStrategy evictionStrategy;
    private long evictionWakeUpInterval = Long.MIN_VALUE;
    private int evictionMaxEntries = Integer.MIN_VALUE;
    private long expirationLifespan = Long.MIN_VALUE;
    private long expirationMaxIdle = Long.MIN_VALUE;

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.evictionStrategy;
    }

    public void setEvictionStrategy(String evictionStrategy) {
        this.evictionStrategy = EvictionStrategy.valueOf((String)this.uc(evictionStrategy));
    }

    public long getEvictionWakeUpInterval() {
        return this.evictionWakeUpInterval;
    }

    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.evictionWakeUpInterval = evictionWakeUpInterval;
    }

    public int getEvictionMaxEntries() {
        return this.evictionMaxEntries;
    }

    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.evictionMaxEntries = evictionMaxEntries;
    }

    public long getExpirationLifespan() {
        return this.expirationLifespan;
    }

    public void setExpirationLifespan(long expirationLifespan) {
        this.expirationLifespan = expirationLifespan;
    }

    public long getExpirationMaxIdle() {
        return this.expirationMaxIdle;
    }

    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.expirationMaxIdle = expirationMaxIdle;
    }

    public Configuration createInfinispanConfiguration() {
        Configuration cacheCfg = new Configuration();
        if (this.evictionStrategy != null) {
            cacheCfg.setEvictionStrategy(this.evictionStrategy);
        }
        if (this.evictionWakeUpInterval != Long.MIN_VALUE) {
            cacheCfg.setEvictionWakeUpInterval(this.evictionWakeUpInterval);
        }
        if (this.evictionMaxEntries != Integer.MIN_VALUE) {
            cacheCfg.setEvictionMaxEntries(this.evictionMaxEntries);
        }
        if (this.expirationLifespan != Long.MIN_VALUE) {
            cacheCfg.setExpirationLifespan(this.expirationLifespan);
        }
        if (this.expirationMaxIdle != Long.MIN_VALUE) {
            cacheCfg.setExpirationMaxIdle(this.expirationMaxIdle);
        }
        return cacheCfg;
    }

    public void validateInfinispanConfiguration(Configuration configuration) throws CacheException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "cache=" + this.cacheName + ", strategy=" + this.evictionStrategy + ", wakeUpInterval=" + this.evictionWakeUpInterval + ", maxEntries=" + this.evictionMaxEntries + ", lifespan=" + this.expirationLifespan + ", maxIdle=" + this.expirationMaxIdle + '}';
    }

    private String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }
}

