/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.infinispan.Cache;

public class TransactionalAccessDelegate {
    protected final Cache cache;

    public TransactionalAccessDelegate(Cache cache) {
        this.cache = cache;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.cache.get(key);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        this.cache.putForExternalRead(key, value);
        return true;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version);
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        this.cache.put(key, value);
        return true;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.cache.put(key, value);
        return true;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void removeAll() throws CacheException {
        this.cache.clear();
    }

    public void evictAll() throws CacheException {
        this.evictOrRemoveAll();
    }

    private void evictOrRemoveAll() throws CacheException {
        this.cache.clear();
    }
}

