/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.collection;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.collection.TransactionalAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadOnlyAccess
extends TransactionalAccess {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyAccess.class);

    ReadOnlyAccess(CollectionRegionImpl region) {
        super(region);
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only region");
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        log.error("Illegal attempt to edit read only item");
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
        log.error("Illegal attempt to edit read only item");
    }
}

