/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.impl;

import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Region;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.infinispan.Cache;
import org.infinispan.context.Flag;

public abstract class BaseRegion
implements Region {
    private final Cache cache;
    private final String name;
    protected final TransactionManager transactionManager;

    public BaseRegion(Cache cache, String name, TransactionManager transactionManager) {
        this.cache = cache;
        this.name = name;
        this.transactionManager = transactionManager;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.name;
    }

    public long getElementCountInMemory() {
        return this.cache.size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return 600;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public Map toMap() {
        return this.cache;
    }

    public void destroy() throws CacheException {
        this.cache.clear();
    }

    public boolean contains(Object key) {
        return CacheHelper.containsKey(this.cache, key, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object suspendAndGet(Object key, Flag opt, boolean suppressTimeout) throws CacheException {
        Transaction tx = this.suspend();
        try {
            if (suppressTimeout) {
                Object object = CacheHelper.getAllowingTimeout(this.cache, key);
                return object;
            }
            Object object = CacheHelper.get(this.cache, key);
            return object;
        }
        finally {
            this.resume(tx);
        }
    }

    protected Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    protected void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }
}

