/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.query;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.infinispan.Cache;
import org.infinispan.context.Flag;

public class QueryResultsRegionImpl
extends BaseTransactionalDataRegion
implements QueryResultsRegion {
    private boolean localOnly;

    public QueryResultsRegionImpl(Cache cache, String name, Properties properties, TransactionManager transactionManager) {
        super(cache, name, null, transactionManager);
        this.localOnly = CacheHelper.isClusteredInvalidation(cache);
    }

    public void evict(Object key) throws CacheException {
        if (this.localOnly) {
            CacheHelper.removeKey(this.getCache(), key, Flag.CACHE_MODE_LOCAL);
        } else {
            CacheHelper.removeKey(this.getCache(), key);
        }
    }

    public void evictAll() throws CacheException {
        if (this.localOnly) {
            CacheHelper.removeAll(this.getCache(), Flag.CACHE_MODE_LOCAL);
        } else {
            CacheHelper.removeAll(this.getCache());
        }
    }

    public Object get(Object key) throws CacheException {
        return this.suspendAndGet(key, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, true);
    }

    public void put(Object key, Object value) throws CacheException {
        if (this.localOnly) {
            CacheHelper.putAllowingTimeout(this.getCache(), key, value, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.CACHE_MODE_LOCAL);
        } else {
            CacheHelper.putAllowingTimeout(this.getCache(), key, value, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        }
    }
}

