/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.timestamp;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.infinispan.impl.BaseGeneralDataRegion;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener
public class TimestampsRegionImpl
extends BaseGeneralDataRegion
implements TimestampsRegion {
    private Map localCache = new ConcurrentHashMap();

    public TimestampsRegionImpl(Cache cache, String name, TransactionManager transactionManager) {
        super(cache, name, transactionManager);
        cache.addListener((Object)this);
        this.populateLocalCache();
    }

    @Override
    public void evict(Object key) throws CacheException {
        CacheHelper.removeKey(this.getCache(), key);
    }

    @Override
    public void evictAll() throws CacheException {
        CacheHelper.removeAll(this.getCache());
    }

    @Override
    public Object get(Object key) throws CacheException {
        Object value = this.localCache.get(key);
        if (value == null && (value = this.suspendAndGet(key, null, false)) != null) {
            this.localCache.put(key, value);
        }
        return value;
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        Transaction tx = this.suspend();
        try {
            CacheHelper.put(this.getCache(), key, value, Flag.FORCE_ASYNCHRONOUS);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.resume(tx);
        }
    }

    @Override
    public void destroy() throws CacheException {
        this.localCache.clear();
        this.getCache().removeListener((Object)this);
        super.destroy();
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.localCache.put(event.getKey(), event.getValue());
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.localCache.remove(event.getKey());
    }

    private void populateLocalCache() {
        Set children = CacheHelper.getKeySet(this.getCache());
        for (Object key : children) {
            this.get(key);
        }
    }
}

