/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Set;
import org.hibernate.cache.CacheException;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHelper {
    private static final Logger log = LoggerFactory.getLogger(CacheHelper.class);

    private CacheHelper() {
    }

    public static boolean isClusteredInvalidation(Cache cache) {
        return CacheHelper.isClusteredInvalidation(cache.getConfiguration().getCacheMode());
    }

    public static boolean isClusteredInvalidation(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.INVALIDATION_ASYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    public static boolean isClusteredReplication(Cache cache) {
        return CacheHelper.isClusteredReplication(cache.getConfiguration().getCacheMode());
    }

    public static boolean isClusteredReplication(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_ASYNC || cacheMode == Configuration.CacheMode.REPL_SYNC;
    }

    public static boolean isSynchronous(Cache cache) {
        return CacheHelper.isSynchronous(cache.getConfiguration().getCacheMode());
    }

    public static boolean isSynchronous(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_SYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    public static Set getKeySet(Cache cache) {
        return cache.keySet();
    }

    public static Object get(Cache cache, Object key) throws CacheException {
        try {
            return cache.get(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static Object getAllowingTimeout(Cache cache, Object key) throws CacheException {
        try {
            return cache.get(key);
        }
        catch (TimeoutException ignored) {
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void put(Cache cache, Object key, Object value) throws CacheException {
        CacheHelper.put(cache, key, value, null);
    }

    public static void put(Cache cache, Object key, Object value, Flag option) throws CacheException {
        try {
            cache.getAdvancedCache().put(key, value, new Flag[]{option});
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void putAllowingTimeout(Cache cache, Object key, Object value, Flag ... option) throws CacheException {
        try {
            cache.getAdvancedCache().put(key, value, option);
        }
        catch (TimeoutException allowed) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static boolean putForExternalRead(Cache cache, Object key, Object value) throws CacheException {
        return CacheHelper.putForExternalRead(cache, key, value, null);
    }

    public static boolean putForExternalRead(Cache cache, Object key, Object value, Flag ... option) throws CacheException {
        try {
            cache.getAdvancedCache().putForExternalRead(key, value, option);
            return true;
        }
        catch (TimeoutException te) {
            log.debug("ignoring write lock acquisition failure");
            return false;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public static void remove(Cache cache, Object key) throws CacheException {
        CacheHelper.remove(cache, key, null);
    }

    public static void remove(Cache cache, Object key, Flag option) throws CacheException {
        try {
            cache.getAdvancedCache().remove(key, (Object)option);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void removeAll(Cache cache) throws CacheException {
        try {
            cache.clear();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void removeAll(Cache cache, Flag option) throws CacheException {
        try {
            cache.getAdvancedCache().clear(new Flag[]{option});
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void removeKey(Cache cache, Object key, Flag option) throws CacheException {
        try {
            cache.getAdvancedCache().remove(key, (Object)option);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void removeKey(Cache cache, Object key) throws CacheException {
        try {
            cache.remove(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static boolean containsKey(Cache cache, Object key, Flag ... flags) {
        try {
            return cache.getAdvancedCache().containsKey(key, flags);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

