/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionalAccessDelegate {
    private static final Log log = LogFactory.getLog(TransactionalAccessDelegate.class);
    protected final CacheAdapter cacheAdapter;
    protected final BaseRegion region;
    protected final PutFromLoadValidator putValidator;

    public TransactionalAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        this.region = region;
        this.cacheAdapter = region.getCacheAdapter();
        this.putValidator = validator;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        Object val = this.cacheAdapter.get(key);
        if (val == null) {
            this.putValidator.registerPendingPut(key);
        }
        return val;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.isPutValid(key)) {
            return false;
        }
        this.cacheAdapter.putForExternalRead(key, value);
        return true;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        boolean trace = log.isTraceEnabled();
        if (!this.region.checkValid()) {
            if (trace) {
                log.trace((Object)"Region not valid");
            }
            return false;
        }
        if (!this.putValidator.isPutValid(key)) {
            if (trace) {
                log.trace((Object)"Put {0} not valid", new Object[]{key});
            }
            return false;
        }
        this.cacheAdapter.putForExternalRead(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (this.cacheAdapter.isClusteredInvalidation()) {
            this.cacheAdapter.withFlags(FlagAdapter.CACHE_MODE_LOCAL).put(key, value);
        } else {
            this.cacheAdapter.put(key, value);
        }
        return true;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.cacheAdapter.put(key, value);
        return true;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    public void remove(Object key) throws CacheException {
        this.putValidator.keyRemoved(key);
        this.cacheAdapter.remove(key);
    }

    public void removeAll() throws CacheException {
        this.putValidator.cleared();
        this.cacheAdapter.clear();
    }

    public void evict(Object key) throws CacheException {
        this.putValidator.keyRemoved(key);
        this.cacheAdapter.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        this.putValidator.cleared();
        Transaction tx = this.region.suspend();
        try {
            CacheHelper.sendEvictAllNotification(this.cacheAdapter, this.region.getAddress());
        }
        finally {
            this.region.resume(tx);
        }
    }
}

