/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.Session;
import org.hibernate.cache.infinispan.JndiInfinispanRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;
import org.hibernate.test.cache.infinispan.functional.Item;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTestCase;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.naming.NonSerializableFactory;
import org.jnp.server.Main;
import org.jnp.server.SingletonNamingServer;
import org.junit.Assert;
import org.junit.Test;

public class JndiRegionFactoryTestCase
extends SingleNodeTestCase {
    private static final Log log = LogFactory.getLog(JndiRegionFactoryTestCase.class);
    private static final String JNDI_NAME = "java:CacheManager";
    private Main namingMain;
    private SingletonNamingServer namingServer;
    private Properties props;
    private boolean bindToJndi = true;
    private EmbeddedCacheManager manager;

    protected void cleanupTest() throws Exception {
        InitialContext ctx = new InitialContext(this.props);
        this.unbind(JNDI_NAME, ctx);
        this.namingServer.destroy();
        this.namingMain.stop();
        this.manager.stop();
    }

    @Override
    protected Class<? extends RegionFactory> getCacheRegionFactory() {
        return JndiInfinispanRegionFactory.class;
    }

    public void afterConfigurationBuilt(Mappings mappings, Dialect dialect) {
        if (this.bindToJndi) {
            try {
                this.namingServer = new SingletonNamingServer();
                this.namingMain = new Main();
                this.namingMain.setInstallGlobalService(true);
                this.namingMain.setPort(-1);
                this.namingMain.start();
                this.props = new Properties();
                this.props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                this.props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                this.manager = new DefaultCacheManager("org/hibernate/cache/infinispan/builder/infinispan-configs.xml", false);
                InitialContext ctx = new InitialContext(this.props);
                this.bind(JNDI_NAME, this.manager, EmbeddedCacheManager.class, ctx);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure to set up JNDI", e);
            }
        }
    }

    @Override
    public void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.infinispan.cachemanager", JNDI_NAME);
        cfg.setProperty("hibernate.jndi.class", "org.jnp.interfaces.NamingContextFactory");
        cfg.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
    }

    @Test
    public void testRedeployment() throws Exception {
        this.addEntityCheckCache(this.sessionFactory());
        this.sessionFactory().close();
        this.bindToJndi = false;
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.configuration().buildSessionFactory((ServiceRegistry)this.serviceRegistry());
        this.addEntityCheckCache(sessionFactory);
        JndiInfinispanRegionFactory regionFactory = (JndiInfinispanRegionFactory)sessionFactory.getSettings().getRegionFactory();
        Cache cache = regionFactory.getCacheManager().getCache("org.hibernate.test.cache.infinispan.functional.Item");
        Assert.assertEquals((Object)ComponentStatus.RUNNING, (Object)cache.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntityCheckCache(SessionFactoryImplementor sessionFactory) throws Exception {
        Session s;
        Item item = new Item("chris", "Chris's Item");
        this.beginTx();
        try {
            s = sessionFactory.openSession();
            s.getTransaction().begin();
            s.persist((Object)item);
            s.getTransaction().commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        this.beginTx();
        try {
            s = sessionFactory.openSession();
            Item found = (Item)s.load(Item.class, (Serializable)item.getId());
            Statistics stats = sessionFactory.getStatistics();
            log.info((Object)stats.toString());
            Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
            Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheHitCount());
            s.delete((Object)found);
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    private void bind(String jndiName, Object who, Class<?> classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    private void unbind(String jndiName, Context ctx) throws Exception {
        NonSerializableFactory.unbind((String)jndiName);
    }
}

