/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.stress;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.test.cache.infinispan.functional.Age;
import org.hibernate.testing.ServiceRegistryBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PutFromLoadStressTestCase {
    static final Log log = LogFactory.getLog(PutFromLoadStressTestCase.class);
    static final boolean isTrace = log.isTraceEnabled();
    static final int NUM_THREADS = 100;
    static final int WARMUP_TIME_SECS = 10;
    static final long RUNNING_TIME_SECS = Integer.getInteger("time", 60).intValue();
    static final long LAUNCH_INTERVAL_MILLIS = 10L;
    static final int NUM_INSTANCES = 5000;
    static SessionFactory sessionFactory;
    static TransactionManager tm;
    final AtomicBoolean run = new AtomicBoolean(true);

    @BeforeClass
    public static void beforeClass() {
        Configuration cfg = new Configuration();
        cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        cfg.setProperty("hibernate.cache.use_query_cache", "true");
        cfg.setProperty("hibernate.cache.region.factory_class", "org.hibernate.cache.infinispan.InfinispanRegionFactory");
        cfg.setProperty("hibernate.transaction.jta.platform", "org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform");
        cfg.setProperty("hibernate.cache.use_minimal_puts", "false");
        PutFromLoadStressTestCase.configureMappings(cfg);
        cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        StandardServiceRegistryImpl registry = ServiceRegistryBuilder.buildServiceRegistry((Map)cfg.getProperties());
        sessionFactory = cfg.buildSessionFactory((ServiceRegistry)registry);
        tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    private static void configureMappings(Configuration cfg) {
        String[] mappings;
        for (String mapping : mappings = new String[]{"cache/infinispan/functional/Item.hbm.xml", "cache/infinispan/functional/Customer.hbm.xml", "cache/infinispan/functional/Contact.hbm.xml"}) {
            cfg.addResource("org/hibernate/test/" + mapping);
        }
        Class<Object>[] annotatedClasses = PutFromLoadStressTestCase.getAnnotatedClasses();
        if (annotatedClasses != null) {
            for (Class<Object> annotatedClass : annotatedClasses) {
                cfg.addAnnotatedClass(annotatedClass);
            }
        }
        cfg.buildMappings();
        Iterator it = cfg.getClassMappings();
        String cacheStrategy = "transactional";
        while (it.hasNext()) {
            PersistentClass clazz = (PersistentClass)it.next();
            if (clazz.isInherited()) continue;
            cfg.setCacheConcurrencyStrategy(clazz.getEntityName(), cacheStrategy);
        }
        it = cfg.getCollectionMappings();
        while (it.hasNext()) {
            Collection coll = (Collection)it.next();
            cfg.setCollectionCacheConcurrencyStrategy(coll.getRole(), cacheStrategy);
        }
    }

    @AfterClass
    public static void afterClass() {
        sessionFactory.close();
    }

    public static Class<Object>[] getAnnotatedClasses() {
        return new Class[]{Age.class};
    }

    @Test
    public void testQueryPerformance() throws Exception {
        this.store();
        this.doTest(false);
    }

    private void store() throws Exception {
        for (int i = 0; i < 5000; ++i) {
            final Age age = new Age();
            age.setAge(i);
            TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Session s = sessionFactory.openSession();
                    s.getTransaction().begin();
                    s.persist((Object)age);
                    s.getTransaction().commit();
                    s.close();
                    return null;
                }
            });
        }
    }

    private void doTest(boolean warmup) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(100);
        try {
            CyclicBarrier barrier = new CyclicBarrier(101);
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>(100);
            for (int i = 0; i < 100; ++i) {
                Future<String> future = executor.submit(new SelectQueryRunner(barrier, warmup, i + 1));
                futures.add(future);
                Thread.sleep(10L);
            }
            barrier.await();
            long timeout = warmup ? 10L : RUNNING_TIME_SECS;
            TimeUnit unit = TimeUnit.SECONDS;
            Thread.sleep(unit.toMillis(timeout));
            this.run.set(false);
            barrier.await(2L, TimeUnit.MINUTES);
            log.infof("[%s] All threads finished, check for exceptions", (Object)this.title(warmup));
            for (Future future : futures) {
                String opsPerMS = (String)future.get();
                if (warmup) continue;
                log.infof("[%s] Operations/ms: %s", (Object)this.title(warmup), (Object)opsPerMS);
            }
            log.infof("[%s] All future gets checked", (Object)this.title(warmup));
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Error in one of the execution threads during %s", (Object)this.title(warmup));
            throw e;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private String title(boolean warmup) {
        return warmup ? "warmup" : "stress";
    }

    public class SelectQueryRunner
    implements Callable<String> {
        final CyclicBarrier barrier;
        final boolean warmup;
        final Integer customerId;

        public SelectQueryRunner(CyclicBarrier barrier, boolean warmup, Integer customerId) {
            this.barrier = barrier;
            this.warmup = warmup;
            this.customerId = customerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            try {
                if (isTrace) {
                    log.tracef("[%s] Wait for all executions paths to be ready to perform calls", (Object)PutFromLoadStressTestCase.this.title(this.warmup));
                }
                this.barrier.await();
                long start = System.nanoTime();
                int runs = 0;
                if (isTrace) {
                    log.tracef("[%s] Start time: %d", (Object)PutFromLoadStressTestCase.this.title(this.warmup), (Object)start);
                }
                this.queryItems();
                long end = System.nanoTime();
                long duration = end - start;
                if (isTrace) {
                    log.tracef("[%s] End time: %d, duration: %d, runs: %d", new Object[]{PutFromLoadStressTestCase.this.title(this.warmup), start, duration, runs});
                }
                String string = this.opsPerMS(duration, runs);
                return string;
            }
            finally {
                if (isTrace) {
                    log.tracef("[%s] Wait for all execution paths to finish", (Object)PutFromLoadStressTestCase.this.title(this.warmup));
                }
                this.barrier.await();
            }
        }

        private void deleteCachedItems() throws Exception {
            TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    sessionFactory.getCache().evictEntityRegion(Age.class);
                    return null;
                }
            });
        }

        private void queryItems() throws Exception {
            TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Session s = sessionFactory.getCurrentSession();
                    Query query = s.getNamedQuery("Age.findAll").setCacheable(true);
                    List result = query.list();
                    Assert.assertFalse((boolean)result.isEmpty());
                    return null;
                }
            });
        }

        private String opsPerMS(long nanos, int ops) {
            long totalMillis = TimeUnit.NANOSECONDS.toMillis(nanos);
            if (totalMillis > 0L) {
                return (long)ops / totalMillis + " ops/ms";
            }
            return "NAN ops/ms";
        }
    }
}

