/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.context.Flag;

public class NodeEnvironment {
    private final Configuration configuration;
    private StandardServiceRegistryImpl serviceRegistry;
    private InfinispanRegionFactory regionFactory;
    private Map<String, EntityRegionImpl> entityRegionMap;
    private Map<String, CollectionRegionImpl> collectionRegionMap;

    public NodeEnvironment(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public StandardServiceRegistryImpl getServiceRegistry() {
        return this.serviceRegistry;
    }

    public EntityRegionImpl getEntityRegion(String name, CacheDataDescription cacheDataDescription) {
        if (this.entityRegionMap == null) {
            this.entityRegionMap = new HashMap<String, EntityRegionImpl>();
            return this.buildAndStoreEntityRegion(name, cacheDataDescription);
        }
        EntityRegionImpl region = this.entityRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreEntityRegion(name, cacheDataDescription);
        }
        return region;
    }

    private EntityRegionImpl buildAndStoreEntityRegion(String name, CacheDataDescription cacheDataDescription) {
        EntityRegionImpl region = (EntityRegionImpl)this.regionFactory.buildEntityRegion(name, this.configuration.getProperties(), cacheDataDescription);
        this.entityRegionMap.put(name, region);
        return region;
    }

    public CollectionRegionImpl getCollectionRegion(String name, CacheDataDescription cacheDataDescription) {
        if (this.collectionRegionMap == null) {
            this.collectionRegionMap = new HashMap<String, CollectionRegionImpl>();
            return this.buildAndStoreCollectionRegion(name, cacheDataDescription);
        }
        CollectionRegionImpl region = this.collectionRegionMap.get(name);
        if (region == null) {
            region = this.buildAndStoreCollectionRegion(name, cacheDataDescription);
            this.collectionRegionMap.put(name, region);
        }
        return region;
    }

    private CollectionRegionImpl buildAndStoreCollectionRegion(String name, CacheDataDescription cacheDataDescription) {
        CollectionRegionImpl region = (CollectionRegionImpl)this.regionFactory.buildCollectionRegion(name, this.configuration.getProperties(), cacheDataDescription);
        return region;
    }

    public void prepare() throws Exception {
        this.serviceRegistry = (StandardServiceRegistryImpl)new ServiceRegistryBuilder().applySettings((Map)this.configuration.getProperties()).buildServiceRegistry();
        this.regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)this.serviceRegistry, this.configuration);
    }

    public void release() throws Exception {
        if (this.entityRegionMap != null) {
            for (final EntityRegionImpl region : this.entityRegionMap.values()) {
                Caches.withinTx((TransactionManager)region.getTransactionManager(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        region.getCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
                        return null;
                    }
                });
                region.getCache().stop();
            }
            this.entityRegionMap.clear();
        }
        if (this.collectionRegionMap != null) {
            for (final CollectionRegionImpl collectionRegion : this.collectionRegionMap.values()) {
                Caches.withinTx((TransactionManager)collectionRegion.getTransactionManager(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        collectionRegion.getCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
                        return null;
                    }
                });
                collectionRegion.getCache().stop();
            }
            this.collectionRegionMap.clear();
        }
        if (this.regionFactory != null) {
            this.regionFactory.stop();
        }
        if (this.serviceRegistry != null) {
            this.serviceRegistry.destroy();
        }
    }
}

