/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.collection;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.test.cache.infinispan.AbstractEntityCollectionRegionTestCase;
import org.infinispan.AdvancedCache;
import org.junit.Assert;

public class CollectionRegionImplTestCase
extends AbstractEntityCollectionRegionTestCase {
    @Override
    protected void supportedAccessTypeTest(RegionFactory regionFactory, Properties properties) {
        CollectionRegion region = regionFactory.buildCollectionRegion("test", properties, null);
        Assert.assertNull((String)"Got TRANSACTIONAL", (Object)region.buildAccessStrategy(AccessType.TRANSACTIONAL).lockRegion());
        try {
            region.buildAccessStrategy(AccessType.NONSTRICT_READ_WRITE);
            Assert.fail((String)"Incorrectly got NONSTRICT_READ_WRITE");
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        try {
            region.buildAccessStrategy(AccessType.READ_WRITE);
            Assert.fail((String)"Incorrectly got READ_WRITE");
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildCollectionRegion(regionName, properties, cdd);
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache("entity").getAdvancedCache();
    }

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        CollectionRegionAccessStrategy strategy = ((CollectionRegion)region).buildAccessStrategy(AccessType.TRANSACTIONAL);
        strategy.putFromLoad(key, value, System.currentTimeMillis(), (Object)new Integer(1));
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((CollectionRegion)region).buildAccessStrategy(AccessType.TRANSACTIONAL).remove(key);
    }
}

