/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.test.cache.infinispan.AbstractRegionImplTestCase;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.AdvancedCache;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractGeneralDataRegionTestCase
extends AbstractRegionImplTestCase {
    private static final Logger log = Logger.getLogger(AbstractGeneralDataRegionTestCase.class);
    protected static final String KEY = "Key";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    protected static final String VALUE3 = "value3";

    protected Configuration createConfiguration() {
        return CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, false, true);
    }

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        ((GeneralDataRegion)region).put(key, value);
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((GeneralDataRegion)region).evict(key);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest();
    }

    private void evictOrRemoveTest() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        boolean invalidation = false;
        this.avoidConcurrentFlush();
        final GeneralDataRegion localRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        cfg = this.createConfiguration();
        regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        final GeneralDataRegion remoteRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        Assert.assertNull((String)"local is clean", (Object)localRegion.get((Object)KEY));
        Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get((Object)KEY));
        this.regionPut(localRegion, KEY, VALUE1);
        Callable<Object> getFromLocalRegion = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AbstractGeneralDataRegionTestCase.this.regionGet(localRegion, AbstractGeneralDataRegionTestCase.KEY);
            }
        };
        Callable<Object> getFromRemoteRegion = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return AbstractGeneralDataRegionTestCase.this.regionGet(remoteRegion, AbstractGeneralDataRegionTestCase.KEY);
            }
        };
        CacheTestUtil.assertEqualsEventually(VALUE1, getFromLocalRegion, 10L, TimeUnit.SECONDS);
        CacheTestUtil.assertEqualsEventually(VALUE1, getFromRemoteRegion, 10L, TimeUnit.SECONDS);
        this.regionEvict(localRegion, KEY);
        CacheTestUtil.assertEqualsEventually(null, getFromLocalRegion, 10L, TimeUnit.SECONDS);
        CacheTestUtil.assertEqualsEventually(null, getFromRemoteRegion, 10L, TimeUnit.SECONDS);
    }

    protected void regionEvict(GeneralDataRegion region, String key) throws Exception {
        region.evict((Object)key);
    }

    protected void regionPut(GeneralDataRegion region, String key, String value) throws Exception {
        region.put((Object)key, (Object)value);
    }

    protected Object regionGet(GeneralDataRegion region, String key) throws Exception {
        return region.get((Object)key);
    }

    protected abstract String getStandardRegionName(String var1);

    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest("entity");
    }

    private void evictOrRemoveAllTest(String configName) throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        AdvancedCache localCache = this.getInfinispanCache(regionFactory);
        this.avoidConcurrentFlush();
        GeneralDataRegion localRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        cfg = this.createConfiguration();
        regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        AdvancedCache remoteCache = this.getInfinispanCache(regionFactory);
        this.avoidConcurrentFlush();
        GeneralDataRegion remoteRegion = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), cfg.getProperties(), null);
        Set keys = localCache.keySet();
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(keys));
        keys = remoteCache.keySet();
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(keys));
        Assert.assertNull((String)"local is clean", (Object)localRegion.get((Object)KEY));
        Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get((Object)KEY));
        this.regionPut(localRegion, KEY, VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)localRegion.get((Object)KEY));
        this.sleep(250L);
        this.regionPut(remoteRegion, KEY, VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)remoteRegion.get((Object)KEY));
        this.sleep(250L);
        localRegion.evictAll();
        this.sleep(250L);
        Assert.assertNull((Object)localRegion.get((Object)KEY));
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(localCache.keySet()));
        Assert.assertEquals(null, (Object)remoteRegion.get((Object)KEY));
        Assert.assertEquals((String)("No valid children in " + keys), (long)0L, (long)this.getValidKeyCount(remoteCache.keySet()));
        Assert.assertEquals((String)"local is clean", null, (Object)localRegion.get((Object)KEY));
        Assert.assertEquals((String)"remote is clean", null, (Object)remoteRegion.get((Object)KEY));
    }
}

