/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.test.cache.infinispan.AbstractGeneralDataRegionTestCase;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.hibernate.testing.TestForIssue;
import org.infinispan.AdvancedCache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class QueryRegionImplTestCase
extends AbstractGeneralDataRegionTestCase {
    private static final Logger log = Logger.getLogger(QueryRegionImplTestCase.class);
    private final BatchModeTransactionManager tm = BatchModeTransactionManager.getInstance();

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildQueryResultsRegion(regionName, properties);
    }

    @Override
    protected String getStandardRegionName(String regionPrefix) {
        return regionPrefix + "/" + StandardQueryCache.class.getName();
    }

    @Override
    protected void regionPut(final GeneralDataRegion region, final String key, final String value) throws Exception {
        Caches.withinTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                region.put((Object)key, (Object)value);
                return null;
            }
        });
    }

    @Override
    protected void regionEvict(final GeneralDataRegion region, final String key) throws Exception {
        Caches.withinTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                region.evict((Object)key);
                return null;
            }
        });
    }

    @Override
    protected Object regionGet(final GeneralDataRegion region, final String key) throws Exception {
        return Caches.withinTx((TransactionManager)this.tm, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return region.get((Object)key);
            }
        });
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache(this.getStandardRegionName("test")).getAdvancedCache();
    }

    @Override
    protected Configuration createConfiguration() {
        return CacheTestUtil.buildCustomQueryCacheConfiguration("test", "replicated-query");
    }

    @Test
    public void testPutDoesNotBlockGet() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        final QueryResultsRegion region = regionFactory.buildQueryResultsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        this.regionPut((GeneralDataRegion)region, "Key", "value1");
        Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
        final CountDownLatch readerLatch = new CountDownLatch(1);
        final CountDownLatch writerLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        final ExceptionHolder holder = new ExceptionHolder();
        Thread reader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Caches.withinTx((TransactionManager)QueryRegionImplTestCase.this.tm, (Callable)new Callable(){

                        public Object call() throws Exception {
                            Assert.assertTrue((!"value2".equals(region.get((Object)"Key")) ? 1 : 0) != 0);
                            return null;
                        }
                    });
                }
                catch (AssertionFailedError e) {
                    holder.addAssertionFailure(e);
                }
                catch (Exception e) {
                    holder.addException(e);
                }
                finally {
                    readerLatch.countDown();
                }
            }
        };
        Thread writer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Caches.withinTx((TransactionManager)QueryRegionImplTestCase.this.tm, (Callable)new Callable(){

                        public Object call() throws Exception {
                            region.put((Object)"Key", (Object)"value2");
                            writerLatch.await();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    holder.addException(e);
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        reader.setDaemon(true);
        writer.setDaemon(true);
        writer.start();
        Assert.assertFalse((String)"Writer is blocking", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
        reader.start();
        Assert.assertTrue((String)"Reader finished promptly", (boolean)readerLatch.await(100L, TimeUnit.MILLISECONDS));
        writerLatch.countDown();
        Assert.assertTrue((String)"Reader finished promptly", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"value2", (Object)region.get((Object)"Key"));
        holder.checkExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDoesNotBlockPut() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        final QueryResultsRegion region = regionFactory.buildQueryResultsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        this.regionPut((GeneralDataRegion)region, "Key", "value1");
        Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
        final AdvancedCache cache = this.getInfinispanCache(regionFactory);
        final CountDownLatch blockerLatch = new CountDownLatch(1);
        final CountDownLatch writerLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        final ExceptionHolder holder = new ExceptionHolder();
        Thread blocker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GetBlocker blocker = new GetBlocker(blockerLatch, "Key");
                try {
                    cache.addListener((Object)blocker);
                    Caches.withinTx((TransactionManager)QueryRegionImplTestCase.this.tm, (Callable)new Callable(){

                        public Object call() throws Exception {
                            return region.get((Object)"Key");
                        }
                    });
                }
                catch (Exception e) {
                    holder.addException(e);
                }
                finally {
                    cache.removeListener((Object)blocker);
                }
            }
        };
        Thread writer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    writerLatch.await();
                    QueryRegionImplTestCase.this.regionPut((GeneralDataRegion)region, "Key", "value2");
                }
                catch (Exception e) {
                    holder.addException(e);
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        blocker.setDaemon(true);
        writer.setDaemon(true);
        try {
            blocker.start();
            writer.start();
            Assert.assertFalse((String)"Blocker is blocking", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
            writerLatch.countDown();
            Assert.assertTrue((String)"Writer finished promptly", (boolean)completionLatch.await(100L, TimeUnit.MILLISECONDS));
            blockerLatch.countDown();
            if (IsolationLevel.REPEATABLE_READ.equals((Object)cache.getCacheConfiguration().locking().isolationLevel())) {
                Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
            } else {
                Assert.assertEquals((Object)"value2", (Object)region.get((Object)"Key"));
            }
            holder.checkExceptions();
        }
        finally {
            blockerLatch.countDown();
        }
    }

    @Test
    @TestForIssue(jiraKey="HHH-7898")
    public void testPutDuringPut() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        final QueryResultsRegion region = regionFactory.buildQueryResultsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        this.regionPut((GeneralDataRegion)region, "Key", "value1");
        Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
        final AdvancedCache cache = this.getInfinispanCache(regionFactory);
        final CountDownLatch blockerLatch = new CountDownLatch(1);
        final CountDownLatch triggerLatch = new CountDownLatch(1);
        final ExceptionHolder holder = new ExceptionHolder();
        Thread blocking = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    PutBlocker blocker = null;
                    try {
                        blocker = new PutBlocker(blockerLatch, triggerLatch, "Key");
                        cache.addListener((Object)blocker);
                        QueryRegionImplTestCase.this.regionPut((GeneralDataRegion)region, "Key", "value2");
                        if (blocker == null) break block8;
                    }
                    catch (Exception e) {
                        block9: {
                            try {
                                holder.addException(e);
                                if (blocker == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (blocker != null) {
                                    cache.removeListener(blocker);
                                }
                                if (triggerLatch.getCount() > 0L) {
                                    triggerLatch.countDown();
                                }
                                throw throwable;
                            }
                            cache.removeListener((Object)blocker);
                        }
                        if (triggerLatch.getCount() > 0L) {
                            triggerLatch.countDown();
                        }
                    }
                    cache.removeListener((Object)blocker);
                }
                if (triggerLatch.getCount() > 0L) {
                    triggerLatch.countDown();
                }
            }
        };
        Thread blocked = new Thread(){

            @Override
            public void run() {
                try {
                    triggerLatch.await();
                    QueryRegionImplTestCase.this.regionPut((GeneralDataRegion)region, "Key", "value3");
                }
                catch (Exception e) {
                    holder.addException(e);
                }
            }
        };
        blocking.setName("blocking-thread");
        blocking.start();
        blocked.setName("blocked-thread");
        blocked.start();
        blocked.join();
        blockerLatch.countDown();
        blocking.join();
        holder.checkExceptions();
        Assert.assertEquals((Object)"value2", (Object)region.get((Object)"Key"));
    }

    @Test
    public void testQueryUpdate() throws Exception {
        Configuration cfg = this.createConfiguration();
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory(new ServiceRegistryBuilder().applySettings((Map)cfg.getProperties()).buildServiceRegistry(), cfg, this.getCacheTestSupport());
        this.avoidConcurrentFlush();
        final QueryResultsRegion region = regionFactory.buildQueryResultsRegion(this.getStandardRegionName("test"), cfg.getProperties());
        final ExceptionHolder holder = new ExceptionHolder();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        this.regionPut((GeneralDataRegion)region, "Key", "value1");
        Thread updater = new Thread(){

            @Override
            public void run() {
                try {
                    Caches.withinTx((TransactionManager)QueryRegionImplTestCase.this.tm, (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
                            region.put((Object)"Key", (Object)"value2");
                            Assert.assertEquals((Object)"value2", (Object)region.get((Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            barrier.await(5L, TimeUnit.SECONDS);
                            region.put((Object)"Key", (Object)"value3");
                            Assert.assertEquals((Object)"value3", (Object)region.get((Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            barrier.await(5L, TimeUnit.SECONDS);
                            return null;
                        }
                    });
                }
                catch (AssertionFailedError e) {
                    holder.addAssertionFailure(e);
                    barrier.reset();
                }
                catch (Exception e) {
                    holder.addException(e);
                    barrier.reset();
                }
            }
        };
        Thread reader = new Thread(){

            @Override
            public void run() {
                try {
                    Caches.withinTx((TransactionManager)QueryRegionImplTestCase.this.tm, (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            barrier.await(5L, TimeUnit.SECONDS);
                            Assert.assertEquals((Object)"value1", (Object)region.get((Object)"Key"));
                            barrier.await(5L, TimeUnit.SECONDS);
                            return null;
                        }
                    });
                }
                catch (AssertionFailedError e) {
                    holder.addAssertionFailure(e);
                    barrier.reset();
                }
                catch (Exception e) {
                    holder.addException(e);
                    barrier.reset();
                }
            }
        };
        updater.start();
        reader.start();
        updater.join();
        reader.join();
        holder.checkExceptions();
        Assert.assertEquals((Object)"value3", (Object)this.regionGet((GeneralDataRegion)region, "Key"));
    }

    private class ExceptionHolder {
        private final List<Exception> exceptions = Collections.synchronizedList(new ArrayList());
        private final List<AssertionFailedError> assertionFailures = Collections.synchronizedList(new ArrayList());

        private ExceptionHolder() {
        }

        public void addException(Exception e) {
            this.exceptions.add(e);
        }

        public void addAssertionFailure(AssertionFailedError e) {
            this.assertionFailures.add(e);
        }

        public void checkExceptions() throws Exception {
            Iterator<Throwable> i$ = this.assertionFailures.iterator();
            if (i$.hasNext()) {
                AssertionFailedError a = i$.next();
                throw a;
            }
            i$ = this.exceptions.iterator();
            if (i$.hasNext()) {
                Exception e = (Exception)i$.next();
                throw e;
            }
        }
    }

    @Listener
    public class PutBlocker {
        private final CountDownLatch blockLatch;
        private final CountDownLatch triggerLatch;
        private final Object key;
        private boolean enabled = true;

        PutBlocker(CountDownLatch blockLatch, CountDownLatch triggerLatch, Object key) {
            this.blockLatch = blockLatch;
            this.triggerLatch = triggerLatch;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheEntryModified
        public void nodeVisisted(CacheEntryModifiedEvent event) {
            if (!event.isPre() && event.getKey().equals(this.key)) {
                try {
                    boolean shouldBlock = false;
                    PutBlocker putBlocker = this;
                    synchronized (putBlocker) {
                        if (this.enabled) {
                            shouldBlock = true;
                            this.triggerLatch.countDown();
                            this.enabled = false;
                        }
                    }
                    if (shouldBlock) {
                        this.blockLatch.await();
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted waiting for latch", (Throwable)e);
                }
            }
        }
    }

    @Listener
    public class GetBlocker {
        private final CountDownLatch latch;
        private final Object key;

        GetBlocker(CountDownLatch latch, Object key) {
            this.latch = latch;
            this.key = key;
        }

        @CacheEntryVisited
        public void nodeVisisted(CacheEntryVisitedEvent event) {
            if (event.isPre() && event.getKey().equals(this.key)) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted waiting for latch", (Throwable)e);
                }
            }
        }
    }
}

