/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.test.cache.infinispan.functional.Contact;
import org.hibernate.test.cache.infinispan.functional.Customer;
import org.hibernate.test.cache.infinispan.functional.cluster.ClusterAwareRegionFactory;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeTestCase;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.collection.ConcurrentSet;
import org.junit.Assert;
import org.junit.Test;

public class EntityCollectionInvalidationTestCase
extends DualNodeTestCase {
    private static final Log log = LogFactory.getLog(EntityCollectionInvalidationTestCase.class);
    private static final long SLEEP_TIME = 50L;
    private static final Integer CUSTOMER_ID = new Integer(1);
    static int test = 0;

    @Test
    public void testAll() throws Exception {
        log.info((Object)"*** testAll()");
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        Cache localCustomerCache = localManager.getCache(Customer.class.getName());
        Cache localContactCache = localManager.getCache(Contact.class.getName());
        Cache localCollectionCache = localManager.getCache(Customer.class.getName() + ".contacts");
        MyListener localListener = new MyListener("local");
        localCustomerCache.addListener((Object)localListener);
        localContactCache.addListener((Object)localListener);
        localCollectionCache.addListener((Object)localListener);
        DualNodeJtaTransactionManagerImpl localTM = DualNodeJtaTransactionManagerImpl.getInstance("local");
        EmbeddedCacheManager remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        Cache remoteCustomerCache = remoteManager.getCache(Customer.class.getName());
        Cache remoteContactCache = remoteManager.getCache(Contact.class.getName());
        Cache remoteCollectionCache = remoteManager.getCache(Customer.class.getName() + ".contacts");
        MyListener remoteListener = new MyListener("remote");
        remoteCustomerCache.addListener((Object)remoteListener);
        remoteContactCache.addListener((Object)remoteListener);
        remoteCollectionCache.addListener((Object)remoteListener);
        DualNodeJtaTransactionManagerImpl remoteTM = DualNodeJtaTransactionManagerImpl.getInstance("remote");
        SessionFactoryImplementor localFactory = this.sessionFactory();
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        try {
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            log.debug((Object)"Create node 0");
            IdContainer ids = this.createCustomer((SessionFactory)localFactory, localTM);
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            this.sleep(50L);
            log.debug((Object)"Find node 0");
            this.getCustomer(ids.customerId, (SessionFactory)localFactory, localTM);
            this.sleep(50L);
            log.debug((Object)"Find(2) node 0");
            localListener.clear();
            this.getCustomer(ids.customerId, (SessionFactory)localFactory, localTM);
            log.debug((Object)"Check cache 0");
            this.assertLoadedFromCache(localListener, ids.customerId, ids.contactIds);
            log.debug((Object)"Find node 1");
            this.getCustomer(ids.customerId, (SessionFactory)remoteFactory, remoteTM);
            log.debug((Object)"Find(2) node 1");
            remoteListener.clear();
            this.getCustomer(ids.customerId, (SessionFactory)remoteFactory, remoteTM);
            log.debug((Object)"Check cache 1");
            this.assertLoadedFromCache(remoteListener, ids.customerId, ids.contactIds);
            remoteListener.clear();
            ids = this.modifyCustomer(ids.customerId, (SessionFactory)remoteFactory, remoteTM);
            this.sleep(250L);
            this.assertLoadedFromCache(remoteListener, ids.customerId, ids.contactIds);
            Assert.assertEquals((long)0L, (long)this.getValidKeyCount(localCollectionCache.keySet()));
            Assert.assertEquals((long)0L, (long)this.getValidKeyCount(localCustomerCache.keySet()));
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            throw e;
        }
        finally {
            log.debug((Object)"Cleaning up");
            this.cleanup((SessionFactory)localFactory, localTM);
        }
    }

    private IdContainer createCustomer(SessionFactory sessionFactory, TransactionManager tm) throws Exception {
        log.debug((Object)"CREATE CUSTOMER");
        tm.begin();
        try {
            Session session = sessionFactory.getCurrentSession();
            Customer customer = new Customer();
            customer.setName("JBoss");
            HashSet<Contact> contacts = new HashSet<Contact>();
            Contact kabir = new Contact();
            kabir.setCustomer(customer);
            kabir.setName("Kabir");
            kabir.setTlf("1111");
            contacts.add(kabir);
            Contact bill = new Contact();
            bill.setCustomer(customer);
            bill.setName("Bill");
            bill.setTlf("2222");
            contacts.add(bill);
            customer.setContacts(contacts);
            session.save((Object)customer);
            tm.commit();
            IdContainer ids = new IdContainer();
            ids.customerId = customer.getId();
            HashSet<Integer> contactIds = new HashSet<Integer>();
            contactIds.add(kabir.getId());
            contactIds.add(bill.getId());
            ids.contactIds = contactIds;
            IdContainer idContainer = ids;
            return idContainer;
        }
        catch (Exception e) {
            log.error((Object)"Caught exception creating customer", (Throwable)e);
            try {
                tm.rollback();
            }
            catch (Exception e1) {
                log.error((Object)"Exception rolling back txn", (Throwable)e1);
            }
            throw e;
        }
        finally {
            log.debug((Object)"CREATE CUSTOMER -  END");
        }
    }

    private Customer getCustomer(Integer id, SessionFactory sessionFactory, TransactionManager tm) throws Exception {
        log.debug((Object)("Find customer with id=" + id));
        tm.begin();
        try {
            Session session = sessionFactory.getCurrentSession();
            Customer customer = this.doGetCustomer(id, session, tm);
            tm.commit();
            Customer customer2 = customer;
            return customer2;
        }
        catch (Exception e) {
            try {
                tm.rollback();
            }
            catch (Exception e1) {
                log.error((Object)"Exception rolling back txn", (Throwable)e1);
            }
            throw e;
        }
        finally {
            log.debug((Object)"Find customer ended.");
        }
    }

    private Customer doGetCustomer(Integer id, Session session, TransactionManager tm) throws Exception {
        Customer customer = (Customer)session.get(Customer.class, (Serializable)id);
        Iterator<Contact> it = customer.getContacts().iterator();
        while (it.hasNext()) {
            it.next().getName();
        }
        return customer;
    }

    private IdContainer modifyCustomer(Integer id, SessionFactory sessionFactory, TransactionManager tm) throws Exception {
        log.debug((Object)("Modify customer with id=" + id));
        tm.begin();
        try {
            Session session = sessionFactory.getCurrentSession();
            IdContainer ids = new IdContainer();
            HashSet<Integer> contactIds = new HashSet<Integer>();
            Customer customer = this.doGetCustomer(id, session, tm);
            customer.setName("NewJBoss");
            ids.customerId = customer.getId();
            Set<Contact> contacts = customer.getContacts();
            for (Contact c : contacts) {
                contactIds.add(c.getId());
            }
            Contact contact = contacts.iterator().next();
            contacts.remove(contact);
            contactIds.remove(contact.getId());
            ids.contactIds = contactIds;
            contact.setCustomer(null);
            session.save((Object)customer);
            tm.commit();
            IdContainer idContainer = ids;
            return idContainer;
        }
        catch (Exception e) {
            try {
                tm.rollback();
            }
            catch (Exception e1) {
                log.error((Object)"Exception rolling back txn", (Throwable)e1);
            }
            throw e;
        }
        finally {
            log.debug((Object)"Find customer ended.");
        }
    }

    private void cleanup(SessionFactory sessionFactory, TransactionManager tm) throws Exception {
        tm.begin();
        try {
            Session session = sessionFactory.getCurrentSession();
            Customer c = (Customer)session.get(Customer.class, (Serializable)CUSTOMER_ID);
            if (c != null) {
                Set<Contact> contacts = c.getContacts();
                Iterator<Contact> it = contacts.iterator();
                while (it.hasNext()) {
                    session.delete((Object)it.next());
                }
                c.setContacts(null);
                session.delete((Object)c);
            }
            tm.commit();
        }
        catch (Exception e) {
            try {
                tm.rollback();
            }
            catch (Exception e1) {
                log.error((Object)"Exception rolling back txn", (Throwable)e1);
            }
            log.error((Object)"Caught exception in cleanup", (Throwable)e);
        }
    }

    private void assertLoadedFromCache(MyListener listener, Integer custId, Set contactIds) {
        Assert.assertTrue((String)("Customer#" + custId + " was in cache"), (boolean)listener.visited.contains("Customer#" + custId));
        for (Integer contactId : contactIds) {
            Assert.assertTrue((String)("Contact#" + contactId + " was in cache"), (boolean)listener.visited.contains("Contact#" + contactId));
            Assert.assertTrue((String)("Contact#" + contactId + " was in cache"), (boolean)listener.visited.contains("Contact#" + contactId));
        }
        Assert.assertTrue((String)("Customer.contacts" + custId + " was in cache"), (boolean)listener.visited.contains("Customer.contacts#" + custId));
    }

    protected int getValidKeyCount(Set keys) {
        return keys.size();
    }

    private class IdContainer {
        Integer customerId;
        Set<Integer> contactIds;

        private IdContainer() {
        }
    }

    @Listener
    public static class MyListener {
        private static final Log log = LogFactory.getLog(MyListener.class);
        private Set<String> visited = new ConcurrentSet();
        private final String name;

        public MyListener(String name) {
            this.name = name;
        }

        public void clear() {
            this.visited.clear();
        }

        public boolean isEmpty() {
            return this.visited.isEmpty();
        }

        @CacheEntryVisited
        public void nodeVisited(CacheEntryVisitedEvent event) {
            log.debug((Object)event.toString());
            if (!event.isPre()) {
                CacheKey cacheKey = (CacheKey)event.getKey();
                Integer primKey = (Integer)cacheKey.getKey();
                String key = event.getCache().getName() + '#' + primKey;
                log.debug((Object)("MyListener[" + this.name + "] - Visiting key " + key));
                String token = ".functional.";
                int index = key.indexOf(token);
                if (index > -1) {
                    key = key.substring(index += token.length());
                    log.debug((Object)("MyListener[" + this.name + "] - recording visit to " + key));
                    this.visited.add(key);
                }
            }
        }
    }
}

