/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.collection;

import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.InvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.collection.CollectionAccess;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.infinispan.AdvancedCache;

public class CollectionRegionImpl
extends BaseTransactionalDataRegion
implements CollectionRegion {
    public CollectionRegionImpl(AdvancedCache cache, String name, TransactionManager transactionManager, CacheDataDescription metadata, RegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, name, transactionManager, metadata, factory, cacheKeysFactory);
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        this.checkAccessType(accessType);
        this.getValidator();
        InvalidationCacheAccessDelegate delegate = InvalidationCacheAccessDelegate.create(this, this.getValidator());
        switch (accessType) {
            case READ_ONLY: 
            case READ_WRITE: 
            case TRANSACTIONAL: {
                return new CollectionAccess(this, delegate);
            }
        }
        throw new CacheException("Unsupported access type [" + accessType.getExternalName() + "]");
    }
}

