/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.Operation;
import org.jipijapa.management.spi.PathAddress;
import org.jipijapa.management.spi.StatisticName;
import org.jipijapa.management.spi.Statistics;

public abstract class HibernateAbstractStatistics
implements Statistics {
    private static final String RESOURCE_BUNDLE = HibernateAbstractStatistics.class.getPackage().getName() + ".LocalDescriptions";
    private static final String RESOURCE_BUNDLE_KEY_PREFIX = "hibernate";
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private Set<String> childrenNames = new HashSet<String>();
    private Set<String> writeableNames = new HashSet<String>();
    private Map<String, Class> types = new HashMap<String, Class>();

    public String getResourceBundleName() {
        return RESOURCE_BUNDLE;
    }

    public String getResourceBundleKeyPrefix() {
        return RESOURCE_BUNDLE_KEY_PREFIX;
    }

    protected EntityManagerFactory getEntityManagerFactory(Object[] args) {
        PathAddress pathAddress = this.getPathAddress(args);
        for (Object arg : args) {
            if (!(arg instanceof EntityManagerFactoryAccess)) continue;
            EntityManagerFactoryAccess entityManagerFactoryAccess = (EntityManagerFactoryAccess)arg;
            return entityManagerFactoryAccess.entityManagerFactory(pathAddress.getValue("hibernate-persistence-unit"));
        }
        return null;
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.getOperations().keySet());
    }

    public Class getType(String name) {
        return this.getTypes().get(name);
    }

    public boolean isOperation(String name) {
        return Operation.class.equals((Object)this.getType(name));
    }

    public boolean isAttribute(String name) {
        return !this.isOperation(name);
    }

    public boolean isWriteable(String name) {
        return this.getWriteableNames().contains(name);
    }

    public Object getValue(String name, EntityManagerFactoryAccess entityManagerFactoryAccess, StatisticName statisticName, PathAddress pathAddress) {
        return this.getOperations().get(name).invoke(new Object[]{entityManagerFactoryAccess, statisticName, pathAddress});
    }

    public void setValue(String name, Object newValue, EntityManagerFactoryAccess entityManagerFactoryAccess, StatisticName statisticName, PathAddress pathAddress) {
        this.getOperations().get(name).invoke(new Object[]{newValue, entityManagerFactoryAccess, statisticName, pathAddress});
    }

    protected EntityManagerFactoryAccess getEntityManagerFactoryAccess(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof EntityManagerFactoryAccess)) continue;
            return (EntityManagerFactoryAccess)arg;
        }
        return null;
    }

    protected PathAddress getPathAddress(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof PathAddress)) continue;
            return (PathAddress)arg;
        }
        return null;
    }

    protected String getStatisticName(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof StatisticName)) continue;
            StatisticName name = (StatisticName)arg;
            return name.getName();
        }
        return null;
    }

    public Set<String> getChildrenNames() {
        return Collections.unmodifiableSet(this.childrenNames);
    }

    public Statistics getChild(String childName) {
        return null;
    }

    public Map<String, Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(Map<String, Operation> operations) {
        this.operations = operations;
    }

    public void setChildrenNames(Set<String> childrenNames) {
        this.childrenNames = childrenNames;
    }

    public Set<String> getWriteableNames() {
        return this.writeableNames;
    }

    public void setWriteableNames(Set<String> writeableNames) {
        this.writeableNames = writeableNames;
    }

    public Map<String, Class> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Class> types) {
        this.types = types;
    }
}

